/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import springfox.documentation.builders.PropertySpecificationBuilder;
import springfox.documentation.schema.CompoundModelSpecification;
import springfox.documentation.schema.ElementFacet;
import springfox.documentation.schema.ModelKeyBuilder;
import springfox.documentation.schema.PropertySpecification;
import springfox.documentation.schema.ReferenceModelSpecification;

public class CompoundModelSpecificationBuilder {
    private final Map<String, PropertySpecificationBuilder> properties = new HashMap<String, PropertySpecificationBuilder>();
    private final List<ReferenceModelSpecification> subclassReferences = new ArrayList<ReferenceModelSpecification>();
    private Integer maxProperties;
    private Integer minProperties;
    private ModelKeyBuilder modelKey;
    private String discriminator;

    private PropertySpecificationBuilder propertyBuilder(String name) {
        return this.properties.computeIfAbsent(name, PropertySpecificationBuilder::new);
    }

    public Function<Consumer<PropertySpecificationBuilder>, CompoundModelSpecificationBuilder> property(@NonNull String name) {
        return property -> {
            property.accept(this.propertyBuilder(name));
            return this;
        };
    }

    public Function<Consumer<PropertySpecificationBuilder>, CompoundModelSpecificationBuilder> propertyIfExists(@NonNull String name) {
        return property -> {
            if (this.properties.containsKey(name)) {
                property.accept(this.propertyBuilder(name));
            } else {
                PropertySpecificationBuilder throwAwayBuilder = new PropertySpecificationBuilder(name);
                property.accept(throwAwayBuilder);
            }
            return this;
        };
    }

    public CompoundModelSpecificationBuilder modelKey(@NonNull Consumer<ModelKeyBuilder> consumer) {
        if (this.modelKey == null) {
            this.modelKey = new ModelKeyBuilder();
        }
        consumer.accept(this.modelKey);
        return this;
    }

    public CompoundModelSpecificationBuilder maxProperties(Integer maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public CompoundModelSpecificationBuilder minProperties(Integer minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public CompoundModelSpecification build() {
        List<PropertySpecification> properties = this.properties.values().stream().map(PropertySpecificationBuilder::build).filter(prop -> prop.getHidden() == false).collect(Collectors.toList());
        if (this.modelKey != null) {
            return new CompoundModelSpecification(this.modelKey.build(), properties, this.maxProperties == null ? properties.size() : this.maxProperties.intValue(), this.minProperties == null ? properties.size() : this.minProperties.intValue(), this.discriminator, this.subclassReferences);
        }
        return null;
    }

    public CompoundModelSpecificationBuilder copyOf(CompoundModelSpecification other) {
        if (other == null) {
            return this;
        }
        return this.modelKey(m -> m.copyOf(other.getModelKey())).properties(other.getProperties()).maxProperties(other.getMaxProperties()).minProperties(other.getMinProperties()).discriminator(other.getDiscriminator()).subclassReferences(other.getSubclassReferences());
    }

    public CompoundModelSpecificationBuilder properties(Collection<PropertySpecification> properties) {
        properties.forEach(each -> this.property(each.getName()).apply(p -> {
            p.type(each.getType()).allowEmptyValue(each.getAllowEmptyValue()).defaultValue(each.getDefaultValue()).deprecated(each.getDeprecated()).description(each.getDescription()).example(each.getExample()).isHidden(each.getHidden()).nullable(each.getNullable()).position(each.getPosition()).readOnly(each.getReadOnly()).required(each.getRequired()).vendorExtensions(each.getVendorExtensions()).xml(each.getXml()).writeOnly(each.getWriteOnly());
            each.getFacets().forEach(f -> p.facetBuilder(f.facetBuilder()).copyOf((ElementFacet)f));
        }));
        return this;
    }

    public CompoundModelSpecificationBuilder discriminator(String discriminator) {
        this.discriminator = discriminator;
        return this;
    }

    public CompoundModelSpecificationBuilder subclassReferences(Collection<ReferenceModelSpecification> subclassReferences) {
        this.subclassReferences.addAll(subclassReferences);
        return this;
    }
}

