/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.constant.JobActionEnum;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.streaming.KafkaConfig;
import org.apache.kylin.metadata.streaming.KafkaConfigManager;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.exception.NotFoundException;
import org.apache.kylin.rest.exception.UnauthorizedException;
import org.apache.kylin.rest.request.Validation;
import org.apache.kylin.rest.response.ErrorResponse;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.tool.restclient.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public class BaseController {
    private static final Logger logger = LoggerFactory.getLogger(BaseController.class);
    protected static final int MAX_NAME_LENGTH = 50;
    @Autowired
    @Qualifier(value="normalRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private ProjectService projectService;
    @Autowired(required=false)
    private JobContext jobContext;
    @Autowired
    protected UserService userService;

    protected Logger getLogger() {
        return logger;
    }

    public ProjectInstance getProject(String project) {
        List<ProjectInstance> projectInstanceList;
        if (null != project && CollectionUtils.isNotEmpty(projectInstanceList = this.projectService.getReadableProjects(project, true))) {
            return projectInstanceList.get(0);
        }
        throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    ErrorResponse handleError(HttpServletRequest req, Throwable ex) {
        Throwable cause;
        this.getLogger().error("", ex);
        Message msg = MsgPicker.getMsg();
        KylinException kylinException = null;
        for (cause = ex; cause != null && cause.getCause() != null; cause = cause.getCause()) {
            if (cause instanceof CannotCreateTransactionException) {
                kylinException = new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_CONNECT_CATALOG, msg.getConnectDatabaseError(), false);
            }
            if (!(cause instanceof KylinException)) continue;
            kylinException = (KylinException)cause;
        }
        if (kylinException != null) {
            cause = kylinException;
        }
        return new ErrorResponse(req.getRequestURL().toString(), cause);
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ExceptionHandler(value={ForbiddenException.class})
    @ResponseBody
    ErrorResponse handleForbidden(HttpServletRequest req, Exception ex) {
        this.getLogger().error("", (Throwable)ex);
        return new ErrorResponse(req.getRequestURL().toString(), ex);
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ExceptionHandler(value={NotFoundException.class})
    @ResponseBody
    ErrorResponse handleNotFound(HttpServletRequest req, Exception ex) {
        this.getLogger().error("", (Throwable)ex);
        return new ErrorResponse(req.getRequestURL().toString(), ex);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={TransactionException.class})
    @ResponseBody
    ErrorResponse handleTransaction(HttpServletRequest req, Throwable ex) {
        Throwable root;
        this.getLogger().error("", ex);
        Throwable throwable = root = ExceptionUtils.getRootCause((Throwable)ex) == null ? ex : ExceptionUtils.getRootCause((Throwable)ex);
        if (root instanceof AccessDeniedException) {
            return this.handleAccessDenied(req, root);
        }
        if (root instanceof KylinException) {
            return this.handleErrorCode(req, root);
        }
        return this.handleError(req, ex);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={AccessDeniedException.class})
    @ResponseBody
    ErrorResponse handleAccessDenied(HttpServletRequest req, Throwable ex) {
        this.getLogger().error("", ex);
        KylinException e = new KylinException((ErrorCodeSupplier)ServerErrorCode.ACCESS_DENIED, MsgPicker.getMsg().getAccessDeny());
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class, IllegalArgumentException.class})
    @ResponseBody
    ErrorResponse handleInvalidRequestParam(HttpServletRequest req, Throwable ex) {
        KylinException e = new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, ex);
        this.getLogger().error("", (Throwable)e);
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    ErrorResponse handleMissingServletRequestParam(HttpServletRequest req, MissingServletRequestParameterException ex) {
        String parameterName = ex.getParameterName();
        KylinException e = new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{parameterName});
        this.getLogger().error("", (Throwable)e);
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)e);
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={KylinException.class})
    @ResponseBody
    ErrorResponse handleErrorCode(HttpServletRequest req, Throwable ex) {
        this.getLogger().error("", ex);
        KylinException cause = (KylinException)ex;
        return new ErrorResponse(req.getRequestURL().toString(), (Throwable)cause);
    }

    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseBody
    ErrorResponse handleInvalidArgument(HttpServletRequest request, MethodArgumentNotValidException ex) {
        ErrorResponse response = new ErrorResponse(request.getRequestURL().toString(), (Throwable)ex);
        Object target = ex.getBindingResult().getTarget();
        if (target instanceof Validation) {
            response.setMsg(((Validation)target).getErrorMessage(ex.getBindingResult().getFieldErrors()));
        } else {
            response.setMsg(ex.getBindingResult().getFieldErrors().stream().map(e -> e.getField() + ":" + e.getDefaultMessage()).collect(Collectors.joining(",")));
        }
        return response;
    }

    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    @ExceptionHandler(value={UnauthorizedException.class})
    @ResponseBody
    ErrorResponse handleUnauthorized(HttpServletRequest req, Throwable ex) {
        KylinException e = new KylinException((ErrorCodeSupplier)ServerErrorCode.USER_UNAUTHORIZED, ex);
        this.getLogger().error("", (Throwable)e);
        return new ErrorResponse(req.getRequestURL().toString(), ex);
    }

    protected void checkRequiredArg(String fieldName, Object fieldValue) {
        if (fieldValue == null || StringUtils.isEmpty((CharSequence)String.valueOf(fieldValue))) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{fieldName});
        }
    }

    public String makeUserNameCaseInSentive(String userName) {
        UserDetails userDetails = this.userService.loadUserByUsername(userName);
        if (userDetails == null) {
            return userName;
        }
        return userDetails.getUsername();
    }

    protected void checkNonNegativeIntegerArg(String fieldName, Object fieldValue) {
        this.checkRequiredArg(fieldName, fieldValue);
        try {
            int i = Integer.parseInt(String.valueOf(fieldValue));
            if (i < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.INTEGER_NON_NEGATIVE_CHECK, new Object[]{fieldName});
        }
    }

    protected void checkBooleanArg(String fieldName, Object fieldValue) {
        this.checkRequiredArg(fieldName, fieldValue);
        String booleanString = String.valueOf(fieldValue);
        if (!"true".equalsIgnoreCase(booleanString) && !"false".equalsIgnoreCase(booleanString)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ARGS_TYPE_CHECK, new Object[]{booleanString, "Boolean"});
        }
    }

    protected void setDownloadResponse(File file, String fileName, String contentType, HttpServletResponse response) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.setDownloadResponse(fileInputStream, fileName, contentType, response);
            response.setContentLength((int)file.length());
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, (Throwable)e);
        }
    }

    protected void setDownloadResponse(InputStream inputStream, String fileName, String contentType, HttpServletResponse response) {
        try (ServletOutputStream output = response.getOutputStream();){
            response.reset();
            response.setContentType(contentType);
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)output);
            output.flush();
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_DOWNLOAD_FILE, (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public HashMap<String, Object> getDataResponse(String name, List<?> result, int offset, int limit) {
        return this.getDataResponse(name, result, result.size(), offset, limit);
    }

    public HashMap<String, Object> getDataResponse(String name, List<?> result, int count, int offset, int limit) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(name, PagingUtil.cutPage(result, (int)offset, (int)limit));
        data.put("size", count);
        return data;
    }

    public String checkProjectName(String project) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_PROJECT_NAME, MsgPicker.getMsg().getEmptyProjectName());
        }
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance prjInstance = projectManager.getProject(project);
        if (prjInstance == null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PROJECT_NOT_EXIST, new Object[]{project});
        }
        return prjInstance.getName();
    }

    protected void checkCollectionRequiredArg(String fieldName, Collection<?> fieldValue) {
        if (CollectionUtils.isEmpty(fieldValue)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{fieldName});
        }
    }

    public void checkParamLength(String paramName, Object param, int length) {
        if (param == null) {
            return;
        }
        String paramStr = JsonUtil.writeValueAsString((Object)param);
        if (paramStr.length() * 2 > length * 1024) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, MsgPicker.getMsg().getParamTooLarge(), paramName, length));
        }
    }

    protected void checkSegmentParams(String[] ids, String[] names) {
        if (ArrayUtils.isNotEmpty((Object[])ids) && ArrayUtils.isNotEmpty((Object[])names)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_CONFLICT_PARAMETER, new Object[0]);
        }
        if (ArrayUtils.isEmpty((Object[])ids) && ArrayUtils.isEmpty((Object[])names)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.SEGMENT_EMPTY_PARAMETER, new Object[0]);
        }
    }

    public <T extends Enum> List<String> formatStatus(List<String> status, Class<T> enumClass) {
        if (status == null) {
            return Lists.newArrayList();
        }
        Set enumStrSet = Arrays.stream(enumClass.getEnumConstants()).map(Objects::toString).collect(Collectors.toSet());
        List<String> formattedStatus = status.stream().filter(Objects::nonNull).map(item -> item.toUpperCase(Locale.ROOT)).collect(Collectors.toList());
        List illegalStatus = formattedStatus.stream().filter(item -> !enumStrSet.contains(item)).collect(Collectors.toList());
        if (!illegalStatus.isEmpty()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"status", "ONLINE, OFFLINE, WARNING, BROKEN"});
        }
        return formattedStatus;
    }

    public void validatePriority(int priority) {
        if (!ExecutablePO.isPriorityValid((int)priority)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.PARAMETER_INVALID_SUPPORT_LIST, new Object[]{"priority", "0, 1, 2, 3, 4"});
        }
    }

    public void checkStreamingOperation(String project, String table) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        KafkaConfig kafkaConf = KafkaConfigManager.getInstance((KylinConfig)config, (String)project).getKafkaConfig(table);
        if (kafkaConf != null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_STREAMING_OPERATION, MsgPicker.getMsg().getStreamingOperationNotSupport());
        }
    }

    protected boolean needRouteToOtherInstance(Map<String, List<String>> nodeWithJobs, String action) {
        if (JobActionEnum.RESUME.name().equalsIgnoreCase(action)) {
            return false;
        }
        Set<String> targetNodes = nodeWithJobs.keySet();
        String local = AddressUtil.getLocalInstance();
        return targetNodes.size() > 1 || targetNodes.size() == 1 && !targetNodes.contains(local);
    }

    protected void forwardRequestToTargetNode(byte[] requestEntity, HttpHeaders headers, String node, String url) throws IOException {
        RestClient client = new RestClient(node);
        client.forwardPut(requestEntity, headers, url, true);
    }
}

