/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.config;

import java.net.URLStreamHandlerFactory;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.jnet.Installer;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.hystrix.NCircuitBreaker;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.transaction.EventListenerRegistry;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.scheduler.ProjectSerialEventBus;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.HostInfoFetcher;
import org.apache.kylin.engine.spark.filter.QueryFiltersCollector;
import org.apache.kylin.engine.spark.utils.SparkJobFactoryUtils;
import org.apache.kylin.metadata.model.util.ComputedColumnUtil;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectLoader;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.streaming.JdbcStreamingJobStatsStore;
import org.apache.kylin.query.util.ComputedColumnRewriter;
import org.apache.kylin.rest.config.initialize.AclTCRListener;
import org.apache.kylin.rest.config.initialize.AfterMetadataReadyEvent;
import org.apache.kylin.rest.config.initialize.CacheCleanListener;
import org.apache.kylin.rest.config.initialize.JobSchedulerListener;
import org.apache.kylin.rest.config.initialize.ModelBrokenListener;
import org.apache.kylin.rest.config.initialize.ProcessStatusListener;
import org.apache.kylin.rest.config.initialize.QueryMetricsListener;
import org.apache.kylin.rest.config.initialize.SparderStartEvent;
import org.apache.kylin.rest.config.initialize.TableSchemaChangeListener;
import org.apache.kylin.rest.config.initialize.UserAclListener;
import org.apache.kylin.rest.service.CommonQueryCacheSupporter;
import org.apache.kylin.rest.service.task.QueryHistoryMetaUpdateScheduler;
import org.apache.kylin.rest.util.GCLogUploadTask;
import org.apache.kylin.rest.util.InitResourceGroupUtils;
import org.apache.kylin.rest.util.JStackDumpTask;
import org.apache.kylin.rest.util.QueryHistoryOffsetUtil;
import org.apache.kylin.streaming.jobs.StreamingJobListener;
import org.apache.kylin.streaming.jobs.scheduler.StreamingScheduler;
import org.apache.kylin.tool.daemon.KapGuardianHATask;
import org.apache.kylin.tool.garbage.CleanTaskExecutorService;
import org.apache.kylin.tool.garbage.PriorityExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.security.web.FilterChainProxy;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.session.web.http.CookieSerializer;

@Configuration
@Order(value=1)
@Profile(value={"!test"})
public class AppInitializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppInitializer.class);
    @Autowired
    TaskScheduler taskScheduler;
    @Autowired(required=false)
    CommonQueryCacheSupporter queryCacheManager;
    @Autowired(required=false)
    HostInfoFetcher hostInfoFetcher;
    @Autowired
    ApplicationContext context;
    @Autowired
    CookieSerializer cookieSerializer;
    JdbcStreamingJobStatsStore streamingJobStatsStore;

    @PostConstruct
    public void init() throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        NCircuitBreaker.start((KapConfig)KapConfig.wrap((KylinConfig)kylinConfig));
        boolean isJob = kylinConfig.isJobNode();
        boolean isDataLoading = kylinConfig.isDataLoadingNode();
        boolean isMetadata = kylinConfig.isMetadataNode();
        boolean isQueryOnly = kylinConfig.isQueryNodeOnly();
        boolean isResource = kylinConfig.isResource();
        kylinConfig.setJDBCDistributedLockURL(kylinConfig.getJDBCDistributedLockURL().toString());
        if (!isQueryOnly) {
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv()).createMetaStoreUuidIfNotExist();
                return true;
            }, (String)"_global");
            if (!isResource) {
                resourceStore.catchup();
            }
            InitResourceGroupUtils.initResourceGroup();
            if (isJob || isDataLoading) {
                EventBusFactory.getInstance().register((Object)new JobSchedulerListener(), false);
                if (kylinConfig.isStreamingConfigEnabled()) {
                    this.streamingJobStatsStore = new JdbcStreamingJobStatsStore(kylinConfig);
                }
                EventBusFactory.getInstance().register((Object)new StreamingJobListener(), true);
            }
            if (isJob || isMetadata) {
                EventBusFactory.getInstance().register((Object)new ModelBrokenListener(), false);
            }
            SparkJobFactoryUtils.initJobFactory();
            ComputedColumnUtil.setEXTRACTOR(ComputedColumnRewriter::extractCcRexNode);
        } else {
            JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(kylinConfig);
            kylinConfig.setQueryHistoryUrl(kylinConfig.getQueryHistoryUrl().toString());
            kylinConfig.setJDBCQueryHistoryURL(kylinConfig.getQueryHistoryUrl().toString());
            kylinConfig.setStreamingStatsUrl(kylinConfig.getStreamingStatsUrl().toString());
            kylinConfig.setJdbcShareStateUrl(kylinConfig.getJdbcShareStateUrl().toString());
            if (kylinConfig.getMetadataStoreType().equals("hdfs")) {
                kylinConfig.setCoreMetadataDBUrl();
                kylinConfig.setProperty("kylin.metadata.url", kylinConfig.getMetadataUrlPrefix() + "@hdfs");
            }
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
            resourceStore.getMetadataStore().setAuditLogStore((AuditLogStore)auditLogStore);
            resourceStore.catchup();
        }
        kylinConfig.setQueryHistoryUrl(kylinConfig.getQueryHistoryUrl().toString());
        kylinConfig.getDistributedLockFactory().initialize();
        if (!isResource) {
            this.warmUpSystemCache();
            this.cacheCcRexNode();
        }
        this.context.publishEvent((ApplicationEvent)new AfterMetadataReadyEvent(this.context));
        if (kylinConfig.isQueryNode()) {
            if (kylinConfig.isSparderAsync()) {
                this.context.publishEvent((ApplicationEvent)new SparderStartEvent.AsyncEvent(this.context));
            } else {
                this.context.publishEvent((ApplicationEvent)new SparderStartEvent.SyncEvent(this.context));
            }
            EventListenerRegistry.getInstance((KylinConfig)kylinConfig).register((EventListenerRegistry.ResourceEventListener)new AclTCRListener(this.queryCacheManager), "acl");
            EventListenerRegistry.getInstance((KylinConfig)kylinConfig).register((EventListenerRegistry.ResourceEventListener)new TableSchemaChangeListener(this.queryCacheManager), "table");
            EventBusFactory.getInstance().register((Object)new QueryMetricsListener(), false);
            if (kylinConfig.isBloomCollectFilterEnabled()) {
                QueryFiltersCollector.initScheduler();
            }
        }
        EventBusFactory.getInstance().register((Object)ProcessStatusListener.getInstance(), true);
        EventListenerRegistry.getInstance((KylinConfig)kylinConfig).register((EventListenerRegistry.ResourceEventListener)new CacheCleanListener(), "cacheInManager");
        EventBusFactory.getInstance().register((Object)new UserAclListener(), true);
        if (kylinConfig.isAllowNonAsciiCharInUrl()) {
            FilterChainProxy filterChainProxy = (FilterChainProxy)this.context.getBean(FilterChainProxy.class);
            filterChainProxy.setFirewall(this.getHttpFirewall());
        }
        this.postInit();
        log.info("Kylin initialization completed.");
        log.info("KylinConfig in env, ID is {}", (Object)kylinConfig.hashCode());
        log.info("KylinConfig in env, metadata is {}", (Object)kylinConfig.getMetadataUrl());
        log.info("KylinConfig in env, working dir is {}", (Object)kylinConfig.getHdfsWorkingDirectory());
        CleanTaskExecutorService.getInstance().bindWorkingPool(() -> PriorityExecutor.newWorkingThreadPool((String)"clean-storages-pool", (int)kylinConfig.getStorageCleanTaskConcurrency()));
    }

    private void warmUpSystemCache() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        List prjInstances = NProjectManager.getInstance((KylinConfig)kylinConfig).listAllProjects();
        prjInstances.forEach(prjInstance -> {
            NProjectLoader.updateCache((String)prjInstance.getName());
            NProjectLoader.removeCache();
        });
        log.info("The system cache is warmed up.");
    }

    private void cacheCcRexNode() {
        Thread thread = new Thread(() -> {
            log.info("cache ComputedColumn RexNode cache.");
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            List projects = NProjectManager.getInstance((KylinConfig)kylinConfig).listAllProjects();
            projects.forEach(prjInstance -> ComputedColumnRewriter.cacheCcRexNode((KylinConfig)kylinConfig, (String)prjInstance.getName()));
        });
        thread.setName("CacheComputedColumnRexNodeThread");
        thread.start();
    }

    private void resetProjectOffsetId() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        List prjInstances = NProjectManager.getInstance((KylinConfig)kylinConfig).listAllProjects();
        prjInstances.forEach(project -> QueryHistoryOffsetUtil.resetOffsetId(project.getName()));
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void afterReady(ApplicationReadyEvent ignoredEvent) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        AppInitializer.setFsUrlStreamHandlerFactory();
        if (kylinConfig.isJobNode() || kylinConfig.isMetadataNode()) {
            this.resetProjectOffsetId();
        }
        if (kylinConfig.getJStackDumpTaskEnabled()) {
            this.taskScheduler.scheduleAtFixedRate((Runnable)new JStackDumpTask(), kylinConfig.getJStackDumpTaskPeriod() * 60000L);
        }
        if (kylinConfig.isUploadGCLogToWorkingDirEnabled()) {
            this.taskScheduler.scheduleAtFixedRate((Runnable)new GCLogUploadTask(), kylinConfig.getGCLogUploadTaskPeriod() * 60000L);
        }
        if (kylinConfig.isGuardianEnabled() && kylinConfig.isGuardianHAEnabled()) {
            log.info("Guardian Process ha is enabled, start check scheduler");
            this.taskScheduler.scheduleAtFixedRate((Runnable)new KapGuardianHATask(), new Date(System.currentTimeMillis() + kylinConfig.getGuardianHACheckInitDelay() * 1000L), kylinConfig.getGuardianHACheckInterval() * 1000L);
        }
        this.taskScheduler.scheduleAtFixedRate((Runnable)new ProjectSerialEventBus.TimingDispatcher(), ProjectSerialEventBus.TimingDispatcher.INTERVAL);
        this.initSchedule();
    }

    private void initSchedule() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig.isJobNode() || kylinConfig.isDataLoadingNode()) {
            StreamingScheduler ss = StreamingScheduler.getInstance();
            ss.init();
            if (!ss.getHasStarted().get()) {
                throw new KylinRuntimeException("Streaming Scheduler has not been started");
            }
        }
        if (kylinConfig.getQueryHistoryAccelerateInterval() > 0L) {
            QueryHistoryMetaUpdateScheduler qhMetaUpdateScheduler = QueryHistoryMetaUpdateScheduler.getInstance();
            qhMetaUpdateScheduler.init();
            if (!qhMetaUpdateScheduler.hasStarted()) {
                throw new KylinRuntimeException("Query history accelerate scheduler has not been started");
            }
        }
    }

    private void postInit() {
        AddressUtil.setHostInfoFetcher((HostInfoFetcher)this.hostInfoFetcher);
    }

    private static void setFsUrlStreamHandlerFactory() {
        try {
            Installer.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
        }
        catch (Exception e) {
            log.warn("set Fs URL stream handler factory failed", (Throwable)e);
        }
    }

    @Bean
    public HttpFirewall getHttpFirewall() {
        return new DefaultHttpFirewall();
    }
}

