/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.query.IQueryTransformer;
import org.apache.kylin.source.adhocquery.IPushDownConverter;

public class PowerBIConverter
implements IQueryTransformer,
IPushDownConverter {
    private static final String S0 = "\\s*";
    private static final String SM = "\\s+";
    private static final Pattern PIN_SUM_OF_FN_CONVERT = Pattern.compile("\\s*SUM\\s*\\(\\s*[{]\\s*fn\\s+convert\\s*\\(\\s*([^\\s,]+)\\s*,\\s*(SQL_DOUBLE|DOUBLE)\\s*\\)\\s*[}]\\s*\\)", 2);

    private static String handleSumOfFnConvert(String sql) {
        Matcher m;
        while ((m = PIN_SUM_OF_FN_CONVERT.matcher(sql)).find()) {
            sql = sql.substring(0, m.start()) + " SUM(" + m.group(1).trim() + ")" + sql.substring(m.end());
        }
        return sql;
    }

    public String convert(String originSql, String project, String defaultSchema) {
        return PowerBIConverter.handleSumOfFnConvert(originSql);
    }

    @Override
    public String transform(String sql, String project, String defaultSchema) {
        return PowerBIConverter.handleSumOfFnConvert(sql);
    }
}

