/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update.render;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;

public class DefaultUpdateStatementProvider
implements UpdateStatementProvider {
    private final String updateStatement;
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    private DefaultUpdateStatementProvider(Builder builder) {
        this.updateStatement = Objects.requireNonNull(builder.updateStatement);
        this.parameters.putAll(builder.parameters);
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public String getUpdateStatement() {
        return this.updateStatement;
    }

    public static Builder withUpdateStatement(String updateStatement) {
        return new Builder().withUpdateStatement(updateStatement);
    }

    public static class Builder {
        private String updateStatement;
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        public Builder withUpdateStatement(String updateStatement) {
            this.updateStatement = updateStatement;
            return this;
        }

        public Builder withParameters(Map<String, Object> parameters) {
            this.parameters.putAll(parameters);
            return this;
        }

        public DefaultUpdateStatementProvider build() {
            return new DefaultUpdateStatementProvider(this);
        }
    }
}

