/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerInfoUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String UNKNOWN = "UNKNOWN";
    private static final String COMMIT_SHA1_V15 = "commit_SHA1";
    private static final String COMMIT_SHA1_V13 = "commit.sha1";

    private ServerInfoUtil() {
    }

    public static String getKylinClientInformation() {
        StringBuilder buf = new StringBuilder();
        String gitCommit = ServerInfoUtil.getGitCommitInfo();
        String kylinHome = KylinConfig.getKylinHome();
        buf.append("kylin.home: ").append(kylinHome == null ? UNKNOWN : new File(kylinHome).getAbsolutePath()).append("\n");
        String kapVersion = null;
        try {
            File versionFile = new File(kylinHome, "VERSION");
            if (versionFile.exists()) {
                kapVersion = FileUtils.readFileToString((File)versionFile).trim();
            }
        }
        catch (Exception e) {
            logger.error("Failed to get kylin.version. ", (Throwable)e);
        }
        buf.append("kylin.version:").append(kapVersion == null ? UNKNOWN : kapVersion).append("\n");
        buf.append("commit:").append(gitCommit).append("\n");
        buf.append("os.name:").append(System.getProperty("os.name")).append("\n");
        buf.append("os.arch:").append(System.getProperty("os.arch")).append("\n");
        buf.append("os.version:").append(System.getProperty("os.version")).append("\n");
        buf.append("java.version:").append(System.getProperty("java.version")).append("\n");
        buf.append("java.vendor:").append(System.getProperty("java.vendor"));
        return buf.toString();
    }

    public static String getGitCommitInfo() {
        try {
            File commitFile = new File(KylinConfig.getKylinHome(), COMMIT_SHA1_V15);
            if (!commitFile.exists()) {
                commitFile = new File(KylinConfig.getKylinHome(), COMMIT_SHA1_V13);
            }
            List lines = FileUtils.readLines((File)commitFile);
            StringBuilder sb = new StringBuilder();
            for (String line : lines) {
                if (line.startsWith("#")) continue;
                sb.append(line).append(";");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

