/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.tool.AbstractInfoExtractorTool;
import org.apache.kylin.tool.JobDiagInfoTool;
import org.apache.kylin.tool.QueryDiagInfoTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;

public class DiagK8sTool
extends AbstractInfoExtractorTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    HttpHeaders headers;
    private static final Option OPTION_QUERY_ID = OptionBuilder.getInstance().withArgName("query").hasArg().isRequired(false).withDescription("specify the Query ID to extract information. ").create("query");
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().withArgName("project").hasArg().isRequired(false).withDescription("Specify realizations in which project to extract").create("project");
    private static final Option OPTION_JOB_ID = OptionBuilder.getInstance().withArgName("job").hasArg().isRequired(false).withDescription("specify the Job ID to extract information. ").create("job");

    public DiagK8sTool(HttpHeaders headers, String diagPackageType) {
        this.setPackageType(diagPackageType);
        this.headers = headers;
        this.options.addOption(OPTION_QUERY_ID);
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_JOB_ID);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        long startTime = this.getLongOption(optionsHelper, OPTION_START_TIME, this.getDefaultStartTime());
        long endTime = this.getLongOption(optionsHelper, OPTION_END_TIME, this.getDefaultEndTime());
        String queryId = optionsHelper.getOptionValue(OPTION_QUERY_ID);
        String project = optionsHelper.getOptionValue(OPTION_PROJECT);
        String jobId = optionsHelper.getOptionValue(OPTION_JOB_ID);
        File recordTime = new File(exportDir, "time_used_info");
        if (queryId != null) {
            this.extractQueryDiag(exportDir, recordTime, queryId, project);
        } else if (jobId != null) {
            this.extractJobDiag(exportDir, recordTime, jobId);
        } else {
            this.extractSysDiag(exportDir, recordTime, startTime, endTime);
        }
        this.executeTimeoutTask(this.taskQueue);
        this.executorService.shutdown();
        this.awaitDiagPackageTermination(this.getKapConfig().getDiagPackageTimeout());
    }

    private void dumpMetadata(File exportDir, File recordTime) throws IOException {
        this.dumpMetadata(exportDir, recordTime, "");
    }

    private void dumpMetadata(File exportDir, File recordTime, String project) throws IOException {
        File metaDir = new File(exportDir, "metadata");
        FileUtils.forceMkdir((File)metaDir);
        String[] metaToolArgs = new String[]{"-backup", "-dir", metaDir.getAbsolutePath(), "-compress", "false", "-excludeTableExd", "-project", project};
        this.dumpMetadata(metaToolArgs, recordTime);
    }

    private void exportAuditLog(File exportDir, File recordTime, long startTime, long endTime) throws IOException {
        File auditLogDir = new File(exportDir, "audit_log");
        FileUtils.forceMkdir((File)auditLogDir);
        String[] auditLogToolArgs = new String[]{"-startTime", String.valueOf(startTime), "-endTime", String.valueOf(endTime), "-dir", auditLogDir.getAbsolutePath()};
        this.exportAuditLog(auditLogToolArgs, recordTime);
    }

    private void extractSysDiag(File exportDir, File recordTime, long startTime, long endTime) throws IOException {
        this.dumpMetadata(exportDir, recordTime);
        this.exportAuditLog(exportDir, recordTime, startTime, endTime);
        this.exportRecCandidate(null, null, exportDir, true, recordTime);
        this.exportJobInfo(startTime, endTime, recordTime);
        this.exportFavoriteRule(null, recordTime);
        this.exportAsyncTask(null, recordTime);
        this.exportQueryHistoryOffset(null, recordTime);
        this.exportK8sConf(this.headers, exportDir, recordTime, null);
        this.exportLogFromLoki(exportDir, startTime, endTime, Collections.emptyList(), recordTime);
        this.exportLogFromWorkingDir(exportDir, new ArrayList<String>(), recordTime);
        this.exportSparkLog(exportDir, startTime, endTime, recordTime, null);
        this.exportCandidateLog(exportDir, recordTime, startTime, endTime);
    }

    private void extractQueryDiag(File exportDir, File recordTime, String queryId, String project) throws IOException {
        QueryHistory query = new QueryDiagInfoTool().getQueryByQueryId(queryId);
        if (project == null || !project.equals(query.getProjectName())) {
            logger.error("Can not find the project: {}", (Object)project);
            throw new RuntimeException(String.format(Locale.ROOT, "Can not find the project: %s", project));
        }
        long startTime = query.getQueryTime();
        long endTime = query.getDuration() + startTime;
        List<String> instances = Collections.singletonList(query.getQueryHistoryInfo().getHostName());
        logger.info("query project : {} , startTime : {} , endTime : {}", new Object[]{project, startTime, endTime});
        this.dumpMetadata(exportDir, recordTime, project);
        this.exportQueryHistoryOffset(project, recordTime);
        this.exportK8sConf(this.headers, exportDir, recordTime, ClusterConstant.QUERY);
        this.exportLogFromLoki(exportDir, startTime, endTime, instances, recordTime);
        this.exportLogFromWorkingDir(exportDir, instances, recordTime);
        this.exportSparkLog(exportDir, startTime, endTime, recordTime, queryId);
    }

    private void extractJobDiag(File exportDir, File recordTime, String jobId) throws IOException {
        ExecutablePO job = new JobDiagInfoTool().getJobByJobId(jobId);
        if (null == job) {
            logger.error("Can not find the jobId: {}", (Object)jobId);
            throw new RuntimeException(String.format(Locale.ROOT, "Can not find the jobId: %s", jobId));
        }
        String project = job.getProject();
        String modelId = job.getTargetModelId();
        long startTime = job.getCreateTime();
        long endTime = job.getOutput().getEndTime() != 0L ? job.getOutput().getEndTime() : System.currentTimeMillis();
        List<String> instances = this.extractInstances(job);
        logger.info("job project : {} , startTime : {} , endTime : {}", new Object[]{project, startTime, endTime});
        this.dumpMetadata(exportDir, recordTime, project);
        this.exportAuditLog(exportDir, recordTime, startTime, endTime);
        if (StringUtils.isNotEmpty((CharSequence)modelId)) {
            this.exportRecCandidate(project, modelId, exportDir, false, recordTime);
        }
        this.exportJobInfo(project, jobId, recordTime);
        this.exportK8sConf(this.headers, exportDir, recordTime, ClusterConstant.DATA_LOADING);
        this.exportLogFromLoki(exportDir, startTime, endTime, instances, recordTime);
        this.exportLogFromWorkingDir(exportDir, instances, recordTime);
        this.exportJobSparkLog(exportDir, recordTime, project, jobId, job);
    }

    private List<String> extractInstances(ExecutablePO po) {
        ArrayList<String> instances = new ArrayList<String>();
        po.getTasks().forEach(task -> {
            String instance = (String)task.getOutput().getInfo().get("host_name");
            if (instance != null && !instances.contains(instance)) {
                instances.add(instance);
            }
        });
        return instances;
    }
}

