/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.favorite.AsyncAccelerationTask;
import org.apache.kylin.metadata.favorite.AsyncTaskManager;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.rest.aspect.WaitForSyncBeforeRPC;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.AutoIndexPlanRuleUpdateRequest;
import org.apache.kylin.rest.request.FavoriteRuleUpdateRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ProjectStatisticsResponse;
import org.apache.kylin.rest.service.ProjectSmartService;
import org.apache.kylin.rest.service.QueryHistoryService;
import org.apache.kylin.rest.service.util.AutoIndexPlanRuleUtil;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/projects"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class ProjectRecController
extends NBasicController {
    @Autowired
    @Qualifier(value="projectSmartService")
    private ProjectSmartService projectSmartService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="queryHistoryService")
    private QueryHistoryService qhService;

    protected static void checkUpdateFavoriteRuleArgs(FavoriteRuleUpdateRequest request) {
        if (request.isFreqEnable() && StringUtils.isEmpty((CharSequence)request.getFreqValue())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_FREQUENCY_RULE_VALUE, MsgPicker.getMsg().getFrequencyThresholdCanNotEmpty());
        }
        if (request.isDurationEnable() && (StringUtils.isEmpty((CharSequence)request.getMinDuration()) || StringUtils.isEmpty((CharSequence)request.getMaxDuration()))) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_DURATION_RULE_VALUE, MsgPicker.getMsg().getDelayThresholdCanNotEmpty());
        }
        if (request.isCountEnable() && StringUtils.isEmpty((CharSequence)request.getCountValue())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_COUNT_RULE_VALUE, MsgPicker.getMsg().getFrequencyThresholdCanNotEmpty());
        }
        if (request.isRecommendationEnable() && StringUtils.isEmpty((CharSequence)request.getRecommendationsValue().trim())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_REC_RULE_VALUE, MsgPicker.getMsg().getRecommendationLimitNotEmpty());
        }
        if (StringUtils.isEmpty((CharSequence)request.getMinHitCount())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_MIN_HIT_COUNT, MsgPicker.getMsg().getMinHitCountNotEmpty());
        }
        if (StringUtils.isEmpty((CharSequence)request.getEffectiveDays())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_EFFECTIVE_DAYS, MsgPicker.getMsg().getEffectiveDaysNotEmpty());
        }
        if (StringUtils.isEmpty((CharSequence)request.getUpdateFrequency())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.EMPTY_UPDATE_FREQUENCY, MsgPicker.getMsg().getUpdateFrequencyNotEmpty());
        }
        ProjectRecController.checkRange(request.getRecommendationsValue(), 0, Integer.MAX_VALUE);
        ProjectRecController.checkRange(request.getMinHitCount(), 1, Integer.MAX_VALUE);
        ProjectRecController.checkRange(request.getEffectiveDays(), 1, 30);
        ProjectRecController.checkRange(request.getUpdateFrequency(), 1, Integer.MAX_VALUE);
        ProjectRecController.checkRange(request.getLowFrequencyThreshold(), 0, Integer.MAX_VALUE);
        if (!FavoriteRule.DATE_UNIT_CANDIDATES.contains(request.getFrequencyTimeWindow())) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_DATE_UNIT, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidDateUnit(), request.getFrequencyTimeWindow()));
        }
    }

    private static void checkRange(String value, int start, int end) {
        boolean inRightRange;
        try {
            int i = Integer.parseInt(value);
            inRightRange = i >= start && i <= end;
        }
        catch (Exception e) {
            inRightRange = false;
        }
        if (!inRightRange) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_RANGE, String.format(Locale.ROOT, MsgPicker.getMsg().getInvalidRange(), value, start, end));
        }
    }

    @ApiOperation(value="getFavoriteRules", tags={"SM"}, notes="Update Param: freq_enable, freq_value, count_enable, count_value, duration_enable, min_duration, max_duration, submitter_enable, user_groups")
    @GetMapping(value={"/{project:.+}/favorite_rules"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<Map<String, Object>> getFavoriteRules(@PathVariable(value="project") String project) {
        this.checkProjectName(project);
        this.aclEvaluate.checkProjectWritePermission(project);
        return new EnvelopeResponse("000", (Object)this.projectSmartService.getFavoriteRules(project), "");
    }

    @ApiOperation(value="statistics", tags={"SM"})
    @GetMapping(value={"/statistics"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<ProjectStatisticsResponse> getDashboardStatistics(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        ProjectStatisticsResponse projectStatistics = this.projectSmartService.getProjectStatistics(project);
        projectStatistics.setLastWeekQueryCount(this.qhService.getLastWeekQueryCount(project));
        projectStatistics.setUnhandledQueryCount(this.qhService.getQueryCountToAccelerate(project));
        return new EnvelopeResponse("000", (Object)projectStatistics, "");
    }

    @ApiOperation(value="getAcceleration", tags={"AI"})
    @GetMapping(value={"/acceleration"})
    @ResponseBody
    public EnvelopeResponse<Boolean> isAccelerating(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        AbstractAsyncTask asyncTask = AsyncTaskManager.getInstance((String)project).get("async_acceleration_task");
        return new EnvelopeResponse("000", (Object)((AsyncAccelerationTask)asyncTask).isAlreadyRunning(), "");
    }

    @ApiOperation(value="updateAcceleration", tags={"AI"})
    @PutMapping(value={"/acceleration"})
    @ResponseBody
    @WaitForSyncBeforeRPC
    public EnvelopeResponse<Object> accelerate(@RequestParam(value="project") String project) {
        this.checkProjectName(project);
        this.checkProjectNotSemiAuto(project);
        Set deltaRecs = this.projectSmartService.accelerateManually(project);
        return new EnvelopeResponse("000", (Object)deltaRecs.size(), "");
    }

    @ApiOperation(value="statistics", tags={"AI"})
    @PostMapping(value={"/acceleration_tag"})
    @ResponseBody
    public EnvelopeResponse<Object> cleanAsyncAccelerateTag(@RequestParam(value="project") String project, @RequestParam(value="user") String user) {
        this.checkProjectName(project);
        this.checkRequiredArg("user", user);
        AsyncTaskManager.cleanAccelerationTagByUser((String)project, (String)user);
        return new EnvelopeResponse("000", null, "");
    }

    @ApiOperation(value="updateFavoriteRules", tags={"SM"}, notes="Update Param: freq_enable, freq_value, count_enable, count_value, duration_enable, min_duration, max_duration, submitter_enable, user_groups")
    @PutMapping(value={"/{project:.+}/favorite_rules"})
    @ResponseBody
    public EnvelopeResponse<String> updateFavoriteRules(@RequestBody FavoriteRuleUpdateRequest request) {
        this.checkProjectName(request.getProject());
        this.checkProjectUnmodifiable(request.getProject());
        ProjectRecController.checkUpdateFavoriteRuleArgs(request);
        this.projectSmartService.updateRegularRule(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateAutoIndexPlanRules", tags={"AI"})
    @PutMapping(value={"/{project:.+}/auto_index_plan_rule"})
    @ResponseBody
    public EnvelopeResponse<String> updateAutoIndexPlanRules(@PathVariable(value="project") String project, @RequestBody AutoIndexPlanRuleUpdateRequest request) {
        this.checkProjectName(project);
        this.checkProjectUnmodifiable(project);
        request.setProject(project);
        AutoIndexPlanRuleUtil.checkUpdateFavoriteRuleArgs((AutoIndexPlanRuleUpdateRequest)request);
        this.projectSmartService.updateAutoIndexPlanRule(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="updateIndexPlannerRules", tags={"AI"})
    @PutMapping(value={"/index_planner_rule"})
    @ResponseBody
    public EnvelopeResponse<String> updateIndexPlannerRules(@RequestBody AutoIndexPlanRuleUpdateRequest request) {
        String project = request.getProject();
        this.checkProjectName(project);
        this.checkProjectUnmodifiable(project);
        request.setProject(project);
        this.checkRequiredArg("indexPlannerEnable", request.isIndexPlannerEnable());
        AutoIndexPlanRuleUtil.checkUpdateFavoriteRuleArgs((AutoIndexPlanRuleUpdateRequest)request);
        this.projectSmartService.updateAutoIndexPlanRule(request.getProject(), request);
        return new EnvelopeResponse("000", (Object)"", "");
    }
}

