/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.FileSystemFilterFactory;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.persistence.resources.ModelRawResource;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ZipFileSystemMetadataStoreTest
extends NLocalFileMetadataTestCase {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testListAllZipMeta() {
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().readonly(true).processor(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setMetadataUrl("src/test/resources/ut_meta/@file,zip=1");
            Properties props = config.exportToProperties();
            KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)props);
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)dstConfig);
            FileSystemMetadataStore metadataStore = (FileSystemMetadataStore)store.getMetadataStore();
            NavigableSet set = metadataStore.listAll();
            Assert.assertTrue((boolean)set.contains("MODEL/9852f045-040c-41aa-acf5-597d9507b66a"));
            return 0;
        }).unitName("_global").maxRetry(3).build());
    }

    @Test
    public void testDumpZipMeta() {
        StorageURL metadataUrl = KylinConfig.getInstanceFromEnv().getMetadataUrl();
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().readonly(true).processor(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setMetadataUrl("src/test/resources/ut_meta/@file,zip=1");
            Properties props = config.exportToProperties();
            KylinConfig sourceConfig = KylinConfig.createKylinConfig((Properties)props);
            ResourceStore sourceStore = ResourceStore.getKylinMetaStore((KylinConfig)sourceConfig);
            FileSystemMetadataStore metadataStore = (FileSystemMetadataStore)sourceStore.getMetadataStore();
            List modelRaw = metadataStore.get(MetadataType.MODEL, new RawResourceFilter(), true, true);
            Assert.assertFalse((boolean)modelRaw.isEmpty());
            KylinConfig descConf = KylinConfig.getInstanceFromEnv();
            descConf.setMetadataUrl(metadataUrl.getIdentifier());
            KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)descConf.exportToProperties());
            metadataStore = (FileSystemMetadataStore)ResourceStore.getKylinMetaStore((KylinConfig)dstConfig).getMetadataStore();
            metadataStore.dump(sourceStore, (Collection)modelRaw.stream().map(RawResource::generateKeyWithType).collect(Collectors.toList()));
            Map<String, RawResource> rawResourceFromUploadFile = ZipFileSystemMetadataStoreTest.getRawResourceFromUploadFile(new File(metadataUrl.getIdentifier() + "/metadata.zip"));
            Assert.assertTrue((boolean)rawResourceFromUploadFile.containsKey("MODEL/9852f045-040c-41aa-acf5-597d9507b66a"));
            return 0;
        }).unitName("_global").maxRetry(3).build());
    }

    @Test
    public void testGetZipMeta() {
        UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().processor(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setMetadataUrl("src/test/resources/ut_meta/@file,zip=1");
            Properties props = config.exportToProperties();
            KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)props);
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)dstConfig);
            RawResource resource = store.getResource("MODEL/9852f045-040c-41aa-acf5-597d9507b66a");
            Assert.assertEquals((Object)"model_agg_update", (Object)resource.getProject());
            Assert.assertEquals((Object)"ssb_model", (Object)((ModelRawResource)resource).getAlias());
            RawResourceFilter rawResourceFilter = new RawResourceFilter();
            rawResourceFilter.addConditions(new RawResourceFilter.Condition("alias", Collections.singletonList("ssb_"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE));
            rawResourceFilter.addConditions(new RawResourceFilter.Condition("project", Collections.singletonList("MODEL_AGG_UPDATE"), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE));
            List model = store.getMatchedResourcesWithoutContent("MODEL", rawResourceFilter);
            Assert.assertEquals((long)1L, (long)model.size());
            FileSystemMetadataStore metadataStore = (FileSystemMetadataStore)store.getMetadataStore();
            List rawResources = metadataStore.get(MetadataType.MODEL, rawResourceFilter, true, true);
            Assert.assertEquals((long)1L, (long)rawResources.size());
            rawResourceFilter = new RawResourceFilter();
            rawResourceFilter.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("MODEL_agg_update.SSB."), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE));
            FileSystemFilterFactory.FilterContext context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)rawResourceFilter, (MetadataType)MetadataType.TABLE_INFO);
            String resPath = context.getResPath();
            String regex = context.getRegex();
            RawResourceFilter jsonFilter = context.getRawResourceFilter();
            Assert.assertEquals((Object)"TABLE_INFO", (Object)resPath);
            Assert.assertEquals((Object)"(?i).*\\QMODEL_agg_update.SSB.\\E.*", (Object)regex);
            Assertions.assertThat((boolean)jsonFilter.getConditions().isEmpty()).isTrue();
            Assert.assertFalse((boolean)context.isWholePath());
            rawResources = metadataStore.get(MetadataType.TABLE_INFO, rawResourceFilter, true, true);
            Assert.assertEquals((long)2L, (long)rawResources.size());
            ArrayList<String> metakeys = new ArrayList<String>();
            metakeys.add("model_agg_update.SSB.P_LINEORDER");
            metakeys.add("model_agg_update.SSB.CUSTOMER");
            rawResources.forEach(x -> Assert.assertTrue((boolean)metakeys.contains(x.getMetaKey())));
            RawResourceFilter filter1 = new RawResourceFilter();
            filter1.addConditions(new RawResourceFilter.Condition("metaKey", Arrays.asList("model_agg_update.SSB.P_LINEORDER", "123"), RawResourceFilter.Operator.IN));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter1, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"\\Qmodel_agg_update.SSB.P_LINEORDER.json\\E|\\Q123.json\\E", (Object)context.getRegex());
            List tableInfo = store.getMatchedResourcesWithoutContent("TABLE_INFO", filter1);
            Assert.assertEquals((long)1L, (long)tableInfo.size());
            Assert.assertEquals((Object)"model_agg_update.SSB.P_LINEORDER", (Object)((RawResource)tableInfo.get(0)).getMetaKey());
            RawResourceFilter filter2 = new RawResourceFilter();
            filter2.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("model_agg_update.ssb.p_lineorder"), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter2, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"(?i)\\Qmodel_agg_update.ssb.p_lineorder.json\\E", (Object)context.getRegex());
            tableInfo = store.getMatchedResourcesWithoutContent("TABLE_INFO", filter2);
            Assert.assertEquals((long)1L, (long)tableInfo.size());
            Assert.assertEquals((Object)"model_agg_update.SSB.P_LINEORDER", (Object)((RawResource)tableInfo.get(0)).getMetaKey());
            return 0;
        }).unitName("_global").maxRetry(1).build());
    }

    public static Map<String, RawResource> getRawResourceFromUploadFile(File uploadFile) {
        Map resourceMap = FileSystemMetadataStore.getFilesFromCompressedFile((Path)new Path(uploadFile.toURI()), (FileSystemMetadataStore.CompressHandlerInterface)new FileSystemMetadataStore.CompressHandler(), (FileSystem)HadoopUtil.getWorkingFileSystem());
        HashMap filesFromCompressedFile = Maps.newHashMap();
        resourceMap.forEach((k, v) -> filesFromCompressedFile.put(k.replaceAll(".json", ""), v));
        return filesFromCompressedFile;
    }
}

