/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.FileSystemFilterFactory;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.resources.ModelRawResource;
import org.apache.kylin.common.persistence.resources.ProjectRawResource;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;

public class FileSystemMetadataStoreTest
extends NLocalFileMetadataTestCase {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata(new String[0]);
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testPathFilter() {
        RawResourceFilter rawResourceFilter = new RawResourceFilter();
        rawResourceFilter.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("DEFAULT.TEST_KYLIN_FACT"), RawResourceFilter.Operator.EQUAL));
        FileSystemFilterFactory.FilterContext context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)rawResourceFilter, (MetadataType)MetadataType.TABLE_INFO);
        String resPath = context.getResPath();
        String regex = context.getRegex();
        RawResourceFilter jsonFilter = context.getRawResourceFilter();
        boolean isWholePath = context.isWholePath();
        Assert.assertEquals((Object)"TABLE_INFO/DEFAULT.TEST_KYLIN_FACT.json", (Object)resPath);
        Assert.assertNull((Object)regex);
        Assertions.assertThat((boolean)jsonFilter.getConditions().isEmpty()).isTrue();
        Assert.assertTrue((boolean)isWholePath);
        rawResourceFilter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.GT, (String)"createTime", (Object)"1604288097900");
        context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)rawResourceFilter, (MetadataType)MetadataType.TABLE_INFO);
        resPath = context.getResPath();
        regex = context.getRegex();
        jsonFilter = context.getRawResourceFilter();
        isWholePath = context.isWholePath();
        Assert.assertEquals((Object)"TABLE_INFO", (Object)resPath);
        Assert.assertNull((Object)regex);
        Assertions.assertThat((int)jsonFilter.getConditions().size()).isSameAs((Object)1);
        Assert.assertFalse((boolean)isWholePath);
    }

    @Test
    public void testRegexTablePathFilter() {
        UnitOfWork.doInTransactionWithRetry(() -> {
            UnitOfWork.get().getCopyForWriteItems().add("TABLE_INFO/pj1.db.abc2");
            ResourceStore store1 = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            String uuid = UUID.randomUUID().toString();
            store1.checkAndPutResource("TABLE_INFO/pj1.db.abc2", ByteSource.wrap((byte[])("{ \"uuid\" : \"" + uuid + "\",\"meta_key\" : \"pj1.db.abc2\",\"name\" : \"abc2\", \"project\" : \"pj1\",\"database\" : \"db\", \"id\" : \"20002\" }").getBytes(DEFAULT_CHARSET)), -1L);
            return 0;
        }, (String)"pj1");
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store1 = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            RawResourceFilter filter = new RawResourceFilter();
            filter.addConditions(new RawResourceFilter.Condition("name", Collections.singletonList("abc2"), RawResourceFilter.Operator.EQUAL));
            List tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter);
            this.checkTable(tableInfo);
            RawResourceFilter filter2 = new RawResourceFilter();
            filter2.addConditions(new RawResourceFilter.Condition("name", Collections.singletonList("ABC2"), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE));
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter2);
            this.checkTable(tableInfo);
            RawResourceFilter filter3 = new RawResourceFilter();
            filter3.addConditions(new RawResourceFilter.Condition("name", Collections.singletonList("B1C"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE));
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter3);
            Assert.assertEquals((long)0L, (long)tableInfo.size());
            RawResourceFilter filter4 = new RawResourceFilter();
            filter4.addConditions("dbName", Arrays.asList("db.xxx", "db"), RawResourceFilter.Operator.IN).addConditions("name", Arrays.asList("abc2", "xxx"), RawResourceFilter.Operator.IN);
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter4);
            this.checkTable(tableInfo);
            RawResourceFilter filter5 = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.GT, (String)"createTime", (Object)"1604288097900");
            store1.getMatchedResourcesWithoutContent("HISTORY_SOURCE_USAGE", filter5);
            RawResourceFilter filter6 = new RawResourceFilter();
            filter6.addConditions("dbName", Collections.singletonList("D"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE).addConditions("name", Collections.singletonList("c2"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE);
            FileSystemFilterFactory.FilterContext context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter6, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"TABLE_INFO", (Object)context.getResPath());
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter6);
            this.checkTable(tableInfo);
            RawResourceFilter filter7 = new RawResourceFilter();
            filter7.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("pj1.db.abc2"), RawResourceFilter.Operator.EQUAL));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter7, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"TABLE_INFO/pj1.db.abc2.json", (Object)context.getResPath());
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter7);
            this.checkTable(tableInfo);
            RawResourceFilter filter8 = new RawResourceFilter();
            filter8.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("pj1.DB"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter8, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"(?i).*\\Qpj1.DB\\E.*", (Object)context.getRegex());
            Assert.assertEquals((Object)"TABLE_INFO", (Object)context.getResPath());
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter8);
            this.checkTable(tableInfo);
            RawResourceFilter filter9 = new RawResourceFilter();
            filter9.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("pj1.db.ABC2"), RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter9, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"(?i)\\Qpj1.db.ABC2.json\\E", (Object)context.getRegex());
            Assert.assertEquals((Object)"TABLE_INFO", (Object)context.getResPath());
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter9);
            this.checkTable(tableInfo);
            RawResourceFilter filter10 = new RawResourceFilter();
            filter10.addConditions(new RawResourceFilter.Condition("metaKey", Arrays.asList("pj1.db.abc2", "123", "321"), RawResourceFilter.Operator.IN));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter10, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"\\Qpj1.db.abc2.json\\E|\\Q123.json\\E|\\Q321.json\\E", (Object)context.getRegex());
            Assert.assertEquals((Object)"TABLE_INFO", (Object)context.getResPath());
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter10);
            this.checkTable(tableInfo);
            RawResourceFilter filter11 = new RawResourceFilter();
            filter11.addConditions(new RawResourceFilter.Condition("metaKey", Collections.emptyList(), RawResourceFilter.Operator.IN));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter11, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"", (Object)context.getRegex());
            Assert.assertEquals((Object)"TABLE_INFO", (Object)context.getResPath());
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter11);
            Assert.assertEquals((long)0L, (long)tableInfo.size());
            RawResourceFilter filter12 = new RawResourceFilter();
            filter12.addConditions(new RawResourceFilter.Condition("metaKey", Arrays.asList("pj1.db.", "123"), RawResourceFilter.Operator.IN));
            context = FileSystemFilterFactory.convertConditionsToFilter((RawResourceFilter)filter12, (MetadataType)MetadataType.TABLE_INFO);
            Assert.assertEquals((Object)"\\Qpj1.db..json\\E|\\Q123.json\\E", (Object)context.getRegex());
            Assert.assertEquals((Object)"TABLE_INFO", (Object)context.getResPath());
            tableInfo = store1.getMatchedResourcesWithoutContent("TABLE_INFO", filter12);
            Assert.assertEquals((long)0L, (long)tableInfo.size());
            return 0;
        }, (String)"pj1");
    }

    void checkTable(List<RawResource> tableInfo) {
        Assert.assertEquals((long)1L, (long)tableInfo.size());
        Assert.assertEquals((Object)"pj1.db.abc2", (Object)tableInfo.get(0).getMetaKey());
    }

    @Test
    public void testGetByModelPathFilter() {
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store1 = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            RawResourceFilter rawResourceFilter = new RawResourceFilter();
            rawResourceFilter.addConditions(new RawResourceFilter.Condition("alias", Collections.singletonList("test_MODEL"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE));
            rawResourceFilter.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("0d146f1a-bdd3-4548-87ac-21c2c6f9a0da"), RawResourceFilter.Operator.EQUAL));
            List tableInfo = store1.getMatchedResourcesWithoutContent("MODEL", rawResourceFilter);
            Assert.assertEquals((long)1L, (long)tableInfo.size());
            return 0;
        }, (String)"default");
    }

    @Test
    public void testGetNotSupportColByModelPathFilter() {
        UnitOfWork.doInTransactionWithRetry(() -> {
            ResourceStore store = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
            RawResource resource = store.getResource("MODEL/0d146f1a-bdd3-4548-87ac-21c2c6f9a0da");
            Assert.assertEquals((Object)"cc_test", (Object)resource.getProject());
            Assert.assertEquals((Object)"test_model", (Object)((ModelRawResource)resource).getAlias());
            RawResourceFilter rawResourceFilter = new RawResourceFilter();
            rawResourceFilter.addConditions(new RawResourceFilter.Condition("factTable", Collections.singletonList("SSB.LINEORDER"), RawResourceFilter.Operator.LIKE_CASE_INSENSITIVE));
            rawResourceFilter.addConditions(new RawResourceFilter.Condition("metaKey", Collections.singletonList("0d146f1a-bdd3-4548-87ac-21c2c6f9a0da"), RawResourceFilter.Operator.EQUAL));
            this.thrown.expect(TransactionException.class);
            store.getMatchedResourcesWithoutContent("MODEL", rawResourceFilter);
            FileSystemMetadataStore metadataStore = (FileSystemMetadataStore)store.getMetadataStore();
            NavigableSet set = metadataStore.listAll();
            Assert.assertTrue((boolean)set.contains("MODEL/9852f045-040c-41aa-acf5-597d9507b66a"));
            return 0;
        }, (String)"default");
    }

    @Test
    public void testValidFileSchema() throws IOException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setMetadataUrl("/home/kylin/demo");
        FileSystemMetadataStore metadataStore = new FileSystemMetadataStore(config);
        this.checkMetadataStore("/home/kylin/demo", metadataStore);
        config.setMetadataUrl("file:///home/kylin/demo");
        metadataStore = new FileSystemMetadataStore(config);
        this.checkMetadataStore("/home/kylin/demo", metadataStore);
        config.setMetadataUrl("file:///home/kylin/demo@file");
        metadataStore = new FileSystemMetadataStore(config);
        this.checkMetadataStore("/home/kylin/demo", metadataStore);
        config.setMetadataUrl("/home/kylin/demo@file");
        metadataStore = new FileSystemMetadataStore(config);
        this.checkMetadataStore("/home/kylin/demo", metadataStore);
        String currentPath = Paths.get("", new String[0]).toFile().getAbsolutePath();
        config.setMetadataUrl("./demo");
        metadataStore = new FileSystemMetadataStore(config);
        this.checkMetadataStore(currentPath + "/demo", metadataStore);
        config.setMetadataUrl("file");
        metadataStore = new FileSystemMetadataStore(config);
        this.checkMetadataStore(currentPath + "/file", metadataStore);
        config.setMetadataUrl("meta@hdfs");
        metadataStore = new FileSystemMetadataStore(config);
        String targetPath = HadoopUtil.getBackupFolder((KylinConfig)config).substring("file://".length()) + "/backup_0";
        this.checkMetadataStore(targetPath, metadataStore);
    }

    private void checkMetadataStore(String path, FileSystemMetadataStore metadataStore) {
        Assert.assertEquals((Object)"file", (Object)metadataStore.fs.getScheme());
        Assert.assertEquals((Object)path, (Object)metadataStore.getRootPath().toUri().getPath());
    }

    @Test
    public void testNotSupportSchema() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setMetadataUrl("/kylin/demo@Unknown");
        Assert.assertThrows(IllegalStateException.class, () -> new FileSystemMetadataStore(config));
    }

    @Test
    public void testListAllInMetadataStoreIsNotAllowed() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        MetadataStore store = ResourceStore.getKylinMetaStore((KylinConfig)config).getMetadataStore();
        Assert.assertThrows(IllegalArgumentException.class, () -> store.get(MetadataType.ALL, new RawResourceFilter(), false, false));
    }

    @Test
    public void testGetFromZip() throws IOException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setMetadataUrl("test,zip=1");
        FileSystemMetadataStore store = (FileSystemMetadataStore)Mockito.spy((Object)new FileSystemMetadataStore(config));
        ProjectRawResource prj = new ProjectRawResource();
        prj.setName("p1");
        prj.setMetaKey("p1");
        prj.setContent("abc".getBytes());
        HashMap<String, ProjectRawResource> mockedResources = new HashMap<String, ProjectRawResource>();
        mockedResources.put("PROJECT/p1.json", prj);
        ((FileSystemMetadataStore)Mockito.doReturn(mockedResources).when((Object)store)).getCompressedFiles();
        this.testAllBranches(store, prj, RawResourceFilter.Operator.EQUAL);
        this.testAllBranches(store, prj, RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE);
    }

    private void testAllBranches(FileSystemMetadataStore store, ProjectRawResource prj, RawResourceFilter.Operator operator) {
        RawResourceFilter filter = new RawResourceFilter();
        filter.addConditions("metaKey", Collections.singletonList("p1"), operator);
        List results = store.get(MetadataType.PROJECT, filter, false, true);
        Assert.assertTrue((results.size() == 1 && results.get(0) == prj ? 1 : 0) != 0);
        results = store.get(MetadataType.PROJECT, filter, false, false);
        Assert.assertTrue((results.size() == 1 && results.get(0) == prj && ((RawResource)results.get(0)).getContent() == null ? 1 : 0) != 0);
        filter = new RawResourceFilter();
        filter.addConditions("metaKey", Collections.singletonList("p2"), operator);
        results = store.get(MetadataType.PROJECT, filter, false, true);
        Assert.assertTrue((boolean)results.isEmpty());
        filter = new RawResourceFilter();
        filter.addConditions("metaKey", Collections.singletonList("p1"), operator);
        filter.addConditions("name", Collections.singletonList("p2"), RawResourceFilter.Operator.EQUAL);
        results = store.get(MetadataType.PROJECT, filter, false, true);
        Assert.assertTrue((boolean)results.isEmpty());
        filter = new RawResourceFilter();
        filter.addConditions("metaKey", Collections.singletonList("p2"), operator);
        filter.addConditions("name", Collections.singletonList("p2"), RawResourceFilter.Operator.EQUAL);
        results = store.get(MetadataType.PROJECT, filter, false, true);
        Assert.assertTrue((boolean)results.isEmpty());
    }
}

