/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.events.GlutenEvent;
import org.apache.gluten.events.GlutenPlanFallbackEvent;
import org.apache.gluten.execution.GlutenPlan;
import org.apache.gluten.extension.columnar.FallbackTag;
import org.apache.gluten.extension.columnar.FallbackTags$;
import org.apache.gluten.logging.LogLevelUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.StringUtils;
import org.apache.spark.sql.execution.GlutenExplainUtils$;
import org.apache.spark.sql.execution.GlutenFallbackReporter$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.ui.GlutenEventUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005}e\u0001B\u000e\u001d\u0001\u001eB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u000f\"A\u0011\u0005\u0001BK\u0002\u0013\u0005a\n\u0003\u0005T\u0001\tE\t\u0015!\u0003P\u0011\u0015!\u0006\u0001\"\u0001V\u0011\u0015I\u0006\u0001\"\u0011[\u0011\u0015i\u0006\u0001\"\u0003_\u0011\u0015\u0019\b\u0001\"\u0003u\u0011\u00151\b\u0001\"\u0003x\u0011\u001dI\b!!A\u0005\u0002iDq! \u0001\u0012\u0002\u0013\u0005a\u0010C\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u0002\u0016!I\u0011\u0011\u0004\u0001\u0002\u0002\u0013\u0005\u00131\u0004\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"!\u000e\u0001\u0003\u0003%\t!a\u000e\t\u0013\u0005\r\u0003!!A\u0005B\u0005\u0015\u0003\"CA*\u0001\u0005\u0005I\u0011AA+\u0011%\ty\u0006AA\u0001\n\u0003\n\t\u0007C\u0005\u0002d\u0001\t\t\u0011\"\u0011\u0002f!I\u0011q\r\u0001\u0002\u0002\u0013\u0005\u0013\u0011N\u0004\b\u0003[b\u0002\u0012AA8\r\u0019YB\u0004#\u0001\u0002r!1AK\u0006C\u0001\u0003sB\u0001\"\u0017\f\u0002\u0002\u0013\u0005\u00151\u0010\u0005\n\u0003\u00033\u0012\u0011!CA\u0003\u0007C\u0011\"!&\u0017\u0003\u0003%I!a&\u0003-\u001dcW\u000f^3o\r\u0006dGNY1dWJ+\u0007o\u001c:uKJT!!\b\u0010\u0002\u0013\u0015DXmY;uS>t'BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011#\u0002\u0001)iq\u0012\u0005cA\u0015/a5\t!F\u0003\u0002,Y\u0005)!/\u001e7fg*\u0011QFH\u0001\tG\u0006$\u0018\r\\=ti&\u0011qF\u000b\u0002\u0005%VdW\r\u0005\u00022e5\tA$\u0003\u000249\tI1\u000b]1sWBc\u0017M\u001c\t\u0003kij\u0011A\u000e\u0006\u0003oa\nq\u0001\\8hO&twM\u0003\u0002:E\u00051q\r\\;uK:L!a\u000f\u001c\u0003\u00191{w\rT3wK2,F/\u001b7\u0011\u0005u\u0002U\"\u0001 \u000b\u0003}\nQa]2bY\u0006L!!\u0011 \u0003\u000fA\u0013x\u000eZ;diB\u0011QhQ\u0005\u0003\tz\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!b\u001a7vi\u0016t7i\u001c8g+\u00059\u0005C\u0001%L\u001b\u0005I%B\u0001&9\u0003\u0019\u0019wN\u001c4jO&\u0011A*\u0013\u0002\r\u000f2,H/\u001a8D_:4\u0017nZ\u0001\fO2,H/\u001a8D_:4\u0007%F\u0001P!\t\u0001\u0016+D\u0001\u001f\u0013\t\u0011fD\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0004ta\u0006\u00148\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007Y;\u0006\f\u0005\u00022\u0001!)Q)\u0002a\u0001\u000f\")\u0011%\u0002a\u0001\u001f\u0006)\u0011\r\u001d9msR\u0011\u0001g\u0017\u0005\u00069\u001a\u0001\r\u0001M\u0001\u0005a2\fg.A\tm_\u001e4\u0015\r\u001c7cC\u000e\\'+Z1t_:$Ba\u00182pcB\u0011Q\bY\u0005\u0003Cz\u0012A!\u00168ji\")1m\u0002a\u0001I\u0006AAn\\4MKZ,G\u000e\u0005\u0002fY:\u0011aM\u001b\t\u0003Ozj\u0011\u0001\u001b\u0006\u0003S\u001a\na\u0001\u0010:p_Rt\u0014BA6?\u0003\u0019\u0001&/\u001a3fM&\u0011QN\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-t\u0004\"\u00029\b\u0001\u0004!\u0017\u0001\u00038pI\u0016t\u0015-\\3\t\u000bI<\u0001\u0019\u00013\u0002\rI,\u0017m]8o\u0003M\u0001(/\u001b8u\r\u0006dGNY1dWJ+\u0017m]8o)\tyV\u000fC\u0003]\u0011\u0001\u0007\u0001'\u0001\nq_N$h)\u00197mE\u0006\u001c7NU3bg>tGCA0y\u0011\u0015a\u0016\u00021\u00011\u0003\u0011\u0019w\u000e]=\u0015\u0007Y[H\u0010C\u0004F\u0015A\u0005\t\u0019A$\t\u000f\u0005R\u0001\u0013!a\u0001\u001f\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A@+\u0007\u001d\u000b\ta\u000b\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011!C;oG\",7m[3e\u0015\r\tiAP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\t\u0003\u000f\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0006+\u0007=\u000b\t!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003mC:<'BAA\u0014\u0003\u0011Q\u0017M^1\n\u00075\f\t#\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u00020A\u0019Q(!\r\n\u0007\u0005MbHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002:\u0005}\u0002cA\u001f\u0002<%\u0019\u0011Q\b \u0003\u0007\u0005s\u0017\u0010C\u0005\u0002B=\t\t\u00111\u0001\u00020\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0012\u0011\r\u0005%\u0013qJA\u001d\u001b\t\tYEC\u0002\u0002Ny\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t&a\u0013\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003/\ni\u0006E\u0002>\u00033J1!a\u0017?\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0011\u0012\u0003\u0003\u0005\r!!\u000f\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a\f\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\b\u0002\r\u0015\fX/\u00197t)\u0011\t9&a\u001b\t\u0013\u0005\u0005C#!AA\u0002\u0005e\u0012AF$mkR,gNR1mY\n\f7m\u001b*fa>\u0014H/\u001a:\u0011\u0005E22\u0003\u0002\f\u0002t\t\u00032!PA;\u0013\r\t9H\u0010\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005=D#\u0002,\u0002~\u0005}\u0004\"B#\u0019\u0001\u00049\u0005\"B\u0011\u0019\u0001\u0004y\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u000b\u000b\t\nE\u0003>\u0003\u000f\u000bY)C\u0002\u0002\nz\u0012aa\u00149uS>t\u0007#B\u001f\u0002\u000e\u001e{\u0015bAAH}\t1A+\u001e9mKJB\u0001\"a%\u001a\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!'\u0011\t\u0005}\u00111T\u0005\u0005\u0003;\u000b\tC\u0001\u0004PE*,7\r\u001e")
public class GlutenFallbackReporter
extends Rule<SparkPlan>
implements LogLevelUtil,
Product,
scala.Serializable {
    private final GlutenConfig glutenConf;
    private final SparkSession spark;

    public static Option<Tuple2<GlutenConfig, SparkSession>> unapply(GlutenFallbackReporter glutenFallbackReporter) {
        return GlutenFallbackReporter$.MODULE$.unapply(glutenFallbackReporter);
    }

    public void logOnLevel(String level, Function0<String> msg) {
        LogLevelUtil.logOnLevel$((LogLevelUtil)this, (String)level, msg);
    }

    public void logOnLevel(String level, Function0<String> msg, Throwable e) {
        LogLevelUtil.logOnLevel$((LogLevelUtil)this, (String)level, msg, (Throwable)e);
    }

    public GlutenConfig glutenConf() {
        return this.glutenConf;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public SparkPlan apply(SparkPlan plan) {
        if (!this.glutenConf().enableFallbackReport()) {
            return plan;
        }
        this.printFallbackReason(plan);
        this.postFallbackReason(plan);
        return plan;
    }

    private void logFallbackReason(String logLevel, String nodeName, String reason) {
        String executionIdInfo = (String)Option$.MODULE$.apply((Object)this.spark().sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY())).map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(10).append("[QueryId=").append((String)id).append("]").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.logOnLevel(logLevel, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Validation failed for plan: ").append(nodeName).append(executionIdInfo).append(", due to: ").append(reason).append(".").toString());
    }

    private void printFallbackReason(SparkPlan plan) {
        String validationLogLevel = this.glutenConf().validationLogLevel();
        plan.foreachUp((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GlutenFallbackReporter.$anonfun$printFallbackReason$1(this, validationLogLevel, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void postFallbackReason(SparkPlan plan) {
        SparkContext sc = this.spark().sparkContext();
        String executionId = sc.getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
        if (executionId == null) {
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Unknown execution id for plan: ").append(plan).toString());
            return;
        }
        StringUtils.PlanStringConcat concat = new StringUtils.PlanStringConcat();
        concat.append("== Physical Plan ==\n");
        Tuple2<Object, Map<String, String>> tuple2 = GlutenExplainUtils$.MODULE$.processPlan(plan, (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)s -> {
            concat.append(s);
            return BoxedUnit.UNIT;
        }, GlutenExplainUtils$.MODULE$.processPlan$default$3());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int numGlutenNodes = tuple2._1$mcI$sp();
        Map fallbackNodeToReason = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)numGlutenNodes), (Object)fallbackNodeToReason);
        Tuple2 tuple23 = tuple22;
        int numGlutenNodes2 = tuple23._1$mcI$sp();
        Map fallbackNodeToReason2 = (Map)tuple23._2();
        GlutenPlanFallbackEvent event = new GlutenPlanFallbackEvent(new StringOps(Predef$.MODULE$.augmentString(executionId)).toLong(), numGlutenNodes2, fallbackNodeToReason2.size(), concat.toString(), fallbackNodeToReason2);
        GlutenEventUtils$.MODULE$.post(sc, (GlutenEvent)event);
    }

    public GlutenFallbackReporter copy(GlutenConfig glutenConf, SparkSession spark) {
        return new GlutenFallbackReporter(glutenConf, spark);
    }

    public GlutenConfig copy$default$1() {
        return this.glutenConf();
    }

    public SparkSession copy$default$2() {
        return this.spark();
    }

    public String productPrefix() {
        return "GlutenFallbackReporter";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        GlutenConfig glutenConfig;
        int n = x$1;
        switch (n) {
            case 0: {
                glutenConfig = this.glutenConf();
                break;
            }
            case 1: {
                glutenConfig = this.spark();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return glutenConfig;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GlutenFallbackReporter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GlutenFallbackReporter)) return false;
        boolean bl = true;
        if (!bl) return false;
        GlutenFallbackReporter glutenFallbackReporter = (GlutenFallbackReporter)((Object)x$1);
        GlutenConfig glutenConfig = this.glutenConf();
        GlutenConfig glutenConfig2 = glutenFallbackReporter.glutenConf();
        if (glutenConfig == null) {
            if (glutenConfig2 != null) {
                return false;
            }
        } else if (!glutenConfig.equals(glutenConfig2)) return false;
        SparkSession sparkSession = this.spark();
        SparkSession sparkSession2 = glutenFallbackReporter.spark();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!glutenFallbackReporter.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$printFallbackReason$1(GlutenFallbackReporter $this, String validationLogLevel$1, SparkPlan x0$1) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = x0$1;
        if (sparkPlan2 instanceof GlutenPlan) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan2 != null && FallbackTags$.MODULE$.nonEmpty(sparkPlan = sparkPlan2)) {
            FallbackTag tag = FallbackTags$.MODULE$.get((TreeNode)sparkPlan);
            $this.logFallbackReason(validationLogLevel$1, sparkPlan.nodeName(), tag.reason());
            sparkPlan.logicalLink().foreach((Function1 & Serializable & scala.Serializable)logicalPlan -> {
                FallbackTags$.MODULE$.add((TreeNode)logicalPlan, (Object)tag, FallbackTag.Converter$.MODULE$.asIs());
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public GlutenFallbackReporter(GlutenConfig glutenConf, SparkSession spark) {
        this.glutenConf = glutenConf;
        this.spark = spark;
        LogLevelUtil.$init$((LogLevelUtil)this);
        Product.$init$((Product)this);
    }
}

