/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.Externalizable;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public abstract class DimensionEncoding
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final byte NULL = -1;

    public static boolean isNull(byte[] bytes, int offset, int length) {
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (bytes[i + offset] == -1) continue;
            return false;
        }
        return true;
    }

    public static Object[] parseEncodingConf(String encoding) {
        String[] parts = encoding.split("\\s*[(),:]\\s*");
        if (parts == null || parts.length == 0 || parts[0].isEmpty()) {
            throw new IllegalArgumentException("Not supported row key col encoding: '" + encoding + "'");
        }
        String encodingName = parts[0];
        String[] encodingArgs = parts[parts.length - 1].isEmpty() ? StringHelper.subArray((String[])parts, (int)1, (int)(parts.length - 1)) : StringHelper.subArray((String[])parts, (int)1, (int)parts.length);
        return new Object[]{encodingName, encodingArgs};
    }

    public abstract int getLengthOfEncoding();

    public abstract void encode(String var1, byte[] var2, int var3);

    public abstract String decode(byte[] var1, int var2, int var3);

    public abstract DataTypeSerializer<Object> asDataTypeSerializer();
}

