/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.compare;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.CompareResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreCompareRequestAttributeDesc
extends GrammarAction<LdapMessageContainer<CompareRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCompareRequestAttributeDesc.class);

    public StoreCompareRequestAttributeDesc() {
        super("Store CompareRequest assertion description");
    }

    public void action(LdapMessageContainer<CompareRequest> container) throws DecoderException {
        CompareRequest compareRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05118_NULL_ATTRIBUTE_DESC, (Object[])new Object[0]);
            LOG.error(msg);
            CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, compareRequest.getName(), null);
        }
        String type = Strings.utf8ToString((byte[])tlv.getValue().getData());
        compareRequest.setAttributeId(type);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05122_COMPARING_ATTRIBUTE_DESCRIPTION, (Object[])new Object[]{compareRequest.getAttributeId()}));
        }
    }
}

