/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.directory.mavibot.btree.NameRevision;
import org.apache.directory.mavibot.btree.NameRevisionComparator;
import org.apache.directory.mavibot.btree.exception.SerializerCreationException;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.ByteArraySerializer;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.mavibot.btree.util.Strings;

class NameRevisionSerializer
extends AbstractElementSerializer<NameRevision> {
    static final NameRevisionSerializer INSTANCE = new NameRevisionSerializer();

    private NameRevisionSerializer() {
        super(NameRevisionComparator.INSTANCE);
    }

    static NameRevision deserialize(byte[] in) {
        return NameRevisionSerializer.deserialize(in, 0);
    }

    static NameRevision deserialize(byte[] in, int start) {
        if (in == null || in.length < 12 + start) {
            throw new SerializerCreationException("Cannot extract a NameRevision from a buffer with not enough bytes");
        }
        long revision = LongSerializer.deserialize(in, start);
        String name = StringSerializer.deserialize(in, 8 + start);
        NameRevision revisionName = new NameRevision(name, revision);
        return revisionName;
    }

    @Override
    public NameRevision fromBytes(byte[] in) {
        return NameRevisionSerializer.deserialize(in, 0);
    }

    @Override
    public NameRevision fromBytes(byte[] in, int start) {
        if (in == null || in.length < 12 + start) {
            throw new SerializerCreationException("Cannot extract a NameRevision from a buffer with not enough bytes");
        }
        long revision = LongSerializer.deserialize(in, start);
        String name = StringSerializer.deserialize(in, 8 + start);
        NameRevision revisionName = new NameRevision(name, revision);
        return revisionName;
    }

    @Override
    public byte[] serialize(NameRevision revisionName) {
        if (revisionName == null) {
            throw new SerializerCreationException("The revisionName instance should not be null ");
        }
        byte[] result = null;
        if (revisionName.getName() != null) {
            byte[] stringBytes = Strings.getBytesUtf8(revisionName.getName());
            int stringLen = stringBytes.length;
            result = new byte[12 + stringBytes.length];
            LongSerializer.serialize(result, 0, revisionName.getRevision());
            if (stringLen > 0) {
                ByteArraySerializer.serialize(result, 8, stringBytes);
            }
        } else {
            result = new byte[12];
            LongSerializer.serialize(result, 0, revisionName.getRevision());
            StringSerializer.serialize(result, 8, null);
        }
        return result;
    }

    static byte[] serialize(byte[] buffer, int start, NameRevision revisionName) {
        if (revisionName.getName() != null) {
            byte[] stringBytes = Strings.getBytesUtf8(revisionName.getName());
            int stringLen = stringBytes.length;
            LongSerializer.serialize(buffer, start, revisionName.getRevision());
            IntSerializer.serialize(buffer, 8 + start, stringLen);
            ByteArraySerializer.serialize(buffer, 12 + start, stringBytes);
        } else {
            LongSerializer.serialize(buffer, start, revisionName.getRevision());
            StringSerializer.serialize(buffer, 8, null);
        }
        return buffer;
    }

    @Override
    public NameRevision deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] revisionBytes = bufferHandler.read(8);
        long revision = LongSerializer.deserialize(revisionBytes);
        byte[] lengthBytes = bufferHandler.read(4);
        int len = IntSerializer.deserialize(lengthBytes);
        switch (len) {
            case 0: {
                return new NameRevision("", revision);
            }
            case -1: {
                return new NameRevision(null, revision);
            }
        }
        byte[] nameBytes = bufferHandler.read(len);
        return new NameRevision(Strings.utf8ToString(nameBytes), revision);
    }

    @Override
    public NameRevision deserialize(ByteBuffer buffer) throws IOException {
        long revision = buffer.getLong();
        int len = buffer.getInt();
        switch (len) {
            case 0: {
                return new NameRevision("", revision);
            }
            case -1: {
                return new NameRevision(null, revision);
            }
        }
        byte[] nameBytes = new byte[len];
        buffer.get(nameBytes);
        return new NameRevision(Strings.utf8ToString(nameBytes), revision);
    }
}

