/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.query;

import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.streams.query.Position;

@InterfaceStability.Evolving
public class PositionBound {
    private final Position position;

    private PositionBound(Position position) {
        this.position = position.copy();
    }

    public static PositionBound unbounded() {
        return new PositionBound(Position.emptyPosition());
    }

    public static PositionBound at(Position position) {
        return new PositionBound(position);
    }

    public boolean isUnbounded() {
        return this.position.isEmpty();
    }

    public Position position() {
        return this.position;
    }

    public String toString() {
        return "PositionBound{position=" + String.valueOf(this.position) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PositionBound that = (PositionBound)o;
        return Objects.equals(this.position, that.position);
    }

    public int hashCode() {
        throw new UnsupportedOperationException("This mutable object is not suitable as a hash key");
    }
}

