/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ReadOnlyEntry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.UnboundIDDSMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SoftDeletedEntry
extends ReadOnlyEntry {
    @NotNull
    public static final String ATTR_SOFT_DELETE_FROM_DN = "ds-soft-delete-from-dn";
    @NotNull
    public static final String ATTR_SOFT_DELETE_REQUESTER_DN = "ds-soft-delete-requester-dn";
    @NotNull
    public static final String ATTR_SOFT_DELETE_REQUESTER_IP_ADDRESS = "ds-soft-delete-requester-ip-address";
    @NotNull
    public static final String ATTR_SOFT_DELETE_TIMESTAMP = "ds-soft-delete-timestamp";
    @NotNull
    public static final String OC_SOFT_DELETED_ENTRY = "ds-soft-delete-entry";
    private static final long serialVersionUID = -3450703461178674797L;
    @Nullable
    private final Date softDeleteTimestamp;
    @NotNull
    private final String softDeleteFromDN;
    @Nullable
    private final String softDeleteRequesterDN;
    @Nullable
    private final String softDeleteRequesterIPAddress;

    public SoftDeletedEntry(@NotNull Entry entry) throws LDAPException {
        super(entry);
        if (!entry.hasObjectClass(OC_SOFT_DELETED_ENTRY)) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, UnboundIDDSMessages.ERR_SOFT_DELETED_ENTRY_MISSING_OC.get(entry.getDN()));
        }
        this.softDeleteFromDN = entry.getAttributeValue(ATTR_SOFT_DELETE_FROM_DN);
        this.softDeleteTimestamp = entry.getAttributeValueAsDate(ATTR_SOFT_DELETE_TIMESTAMP);
        this.softDeleteRequesterDN = entry.getAttributeValue(ATTR_SOFT_DELETE_REQUESTER_DN);
        this.softDeleteRequesterIPAddress = entry.getAttributeValue(ATTR_SOFT_DELETE_REQUESTER_IP_ADDRESS);
        if (this.softDeleteFromDN == null) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, UnboundIDDSMessages.ERR_SOFT_DELETED_ENTRY_MISSING_FROM_DN.get(entry.getDN()));
        }
    }

    @NotNull
    public String getSoftDeleteFromDN() {
        return this.softDeleteFromDN;
    }

    @Nullable
    public Date getSoftDeleteTimestamp() {
        return this.softDeleteTimestamp;
    }

    @Nullable
    public String getSoftDeleteRequesterDN() {
        return this.softDeleteRequesterDN;
    }

    @Nullable
    public String getSoftDeleteRequesterIPAddress() {
        return this.softDeleteRequesterIPAddress;
    }

    @NotNull
    public ReadOnlyEntry getUndeletedEntry() {
        Entry e = this.duplicate();
        e.setDN(this.softDeleteFromDN);
        e.removeAttributeValue("objectClass", OC_SOFT_DELETED_ENTRY);
        e.removeAttribute(ATTR_SOFT_DELETE_FROM_DN);
        e.removeAttribute(ATTR_SOFT_DELETE_TIMESTAMP);
        e.removeAttribute(ATTR_SOFT_DELETE_REQUESTER_DN);
        e.removeAttribute(ATTR_SOFT_DELETE_REQUESTER_IP_ADDRESS);
        return new ReadOnlyEntry(e);
    }

    public static boolean isSoftDeletedEntry(@NotNull Entry entry) {
        return entry.hasObjectClass(OC_SOFT_DELETED_ENTRY) && entry.hasAttribute(ATTR_SOFT_DELETE_FROM_DN);
    }
}

