/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.pulsar.module;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.io.FileNotFoundException;
import java.time.Clock;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.james.backends.pulsar.PulsarClients;
import org.apache.james.backends.pulsar.PulsarConfiguration;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.pulsar.PulsarMailQueue;
import org.apache.james.queue.pulsar.PulsarMailQueueFactory;
import org.apache.james.utils.PropertiesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarQueueModule
extends AbstractModule {
    static final String PULSAR_CONFIGURATION_NAME = "pulsar";
    private static final Logger LOGGER = LoggerFactory.getLogger(PulsarQueueModule.class);

    @Provides
    @Named(value="pulsar")
    @Singleton
    private Configuration rawConfiguration(PropertiesProvider propertiesProvider) throws ConfigurationException {
        try {
            return propertiesProvider.getConfiguration(PULSAR_CONFIGURATION_NAME);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Could not find pulsar configuration file.");
            throw new RuntimeException(e);
        }
    }

    @Provides
    @Singleton
    private PulsarConfiguration pulsarConfiguration(@Named(value="pulsar") Configuration configuration) {
        return PulsarConfiguration.from((Configuration)configuration);
    }

    @Provides
    @Singleton
    private PulsarClients pulsarClients(PulsarConfiguration configuration) {
        return PulsarClients.create((PulsarConfiguration)configuration);
    }

    @Provides
    @Singleton
    public MailQueueFactory<PulsarMailQueue> providePulsarMailQueueFactoryProxy(PulsarConfiguration pulsarConfig, PulsarClients pulsarClients, BlobId.Factory blobIdFactory, MimeMessageStore.Factory mimeFactory, MailQueueItemDecoratorFactory decoratorFactory, MetricFactory metricFactory, GaugeRegistry gaugeRegistry, Clock clock) {
        Store mimeMessageMimeMessagePartsIdStore = mimeFactory.mimeMessageStore();
        return new PulsarMailQueueFactory(pulsarConfig, pulsarClients, blobIdFactory, mimeMessageMimeMessagePartsIdStore, decoratorFactory, metricFactory, gaugeRegistry);
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends ManageableMailQueue> providePulsarManageableMailQueueFactory(MailQueueFactory<PulsarMailQueue> queueFactory) {
        return queueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<? extends MailQueue> providePulsarManageableMailQueueFactoryGenerics(MailQueueFactory<PulsarMailQueue> queueFactory) {
        return queueFactory;
    }

    @Provides
    @Singleton
    public MailQueueFactory<?> mailQueue(Provider<MailQueueFactory<? extends ManageableMailQueue>> provider) {
        return (MailQueueFactory)provider.get();
    }
}

