/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.event;

import com.google.common.base.MoreObjects;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.db.subscription.broker.SubscriptionPrefetchingQueue;
import org.apache.iotdb.db.subscription.event.batch.SubscriptionPipeTabletEventBatch;
import org.apache.iotdb.db.subscription.event.cache.CachedSubscriptionPollResponse;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEmptyEvent;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeEvents;
import org.apache.iotdb.db.subscription.event.pipe.SubscriptionPipeTabletBatchEvents;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventResponse;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventSingleResponse;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventTabletResponse;
import org.apache.iotdb.db.subscription.event.response.SubscriptionEventTsFileResponse;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionCommitContext;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollPayload;
import org.apache.iotdb.rpc.subscription.payload.poll.SubscriptionPollResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionEvent
implements Comparable<SubscriptionEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionEvent.class);
    private static final long INVALID_TIMESTAMP = -1L;
    private final SubscriptionPipeEvents pipeEvents;
    private final SubscriptionEventResponse<CachedSubscriptionPollResponse> response;
    private final SubscriptionCommitContext commitContext;
    private volatile String lastPolledConsumerId = null;
    private final AtomicLong lastPolledTimestamp = new AtomicLong(-1L);
    private final AtomicLong committedTimestamp = new AtomicLong(-1L);
    private volatile String fileName;
    private volatile SubscriptionCommitContext rootCommitContext;
    private static final long NACK_COUNT_REPORT_THRESHOLD = 3L;
    private final AtomicLong nackCount = new AtomicLong();

    public SubscriptionEvent(short responseType, SubscriptionPollPayload payload, SubscriptionCommitContext commitContext) {
        this.pipeEvents = new SubscriptionPipeEmptyEvent();
        this.response = new SubscriptionEventSingleResponse(responseType, payload, commitContext);
        this.commitContext = commitContext;
    }

    public SubscriptionEvent(SubscriptionPollResponse response) {
        this(response.getResponseType(), response.getPayload(), response.getCommitContext());
    }

    public SubscriptionEvent(SubscriptionPipeTabletEventBatch batch, SubscriptionPrefetchingQueue queue) {
        SubscriptionPipeTabletBatchEvents events = new SubscriptionPipeTabletBatchEvents(batch);
        SubscriptionCommitContext commitContext = queue.generateSubscriptionCommitContext();
        this.pipeEvents = events;
        this.response = new SubscriptionEventTabletResponse(batch, queue, events, commitContext, commitContext);
        this.commitContext = commitContext;
        this.rootCommitContext = commitContext;
    }

    public SubscriptionEvent(SubscriptionPipeTabletEventBatch batch, SubscriptionPrefetchingQueue queue, SubscriptionCommitContext rootCommitContext) {
        SubscriptionPipeTabletBatchEvents events = new SubscriptionPipeTabletBatchEvents(batch);
        SubscriptionCommitContext commitContext = queue.generateSubscriptionCommitContext();
        this.pipeEvents = events;
        this.response = new SubscriptionEventTabletResponse(batch, queue, events, commitContext, rootCommitContext);
        this.commitContext = commitContext;
        this.rootCommitContext = rootCommitContext;
    }

    public SubscriptionEvent(SubscriptionPipeEvents pipeEvents, File tsFile, SubscriptionCommitContext commitContext) {
        this.pipeEvents = pipeEvents;
        this.response = new SubscriptionEventTsFileResponse(tsFile, commitContext);
        this.commitContext = commitContext;
        this.fileName = tsFile.getName();
    }

    public SubscriptionPollResponse getCurrentResponse() {
        return this.response.getCurrentResponse();
    }

    public SubscriptionCommitContext getCommitContext() {
        return this.commitContext;
    }

    public void recordCommittedTimestamp() {
        this.committedTimestamp.set(System.currentTimeMillis());
    }

    public boolean isCommitted() {
        if (this.commitContext.getCommitId() == -1L) {
            return true;
        }
        return this.committedTimestamp.get() != -1L;
    }

    public boolean isCommittable() {
        if (this.commitContext.getCommitId() == -1L) {
            return false;
        }
        return this.response.isCommittable();
    }

    public void ack() {
        this.pipeEvents.ack();
    }

    public void cleanUp(boolean force) {
        this.pipeEvents.cleanUp(force);
        this.response.cleanUp();
    }

    public void recordLastPolledTimestamp() {
        long newTimestamp;
        long currentTimestamp;
        while (!this.lastPolledTimestamp.compareAndSet(currentTimestamp = this.lastPolledTimestamp.get(), newTimestamp = Math.max(currentTimestamp, System.currentTimeMillis()))) {
        }
    }

    public boolean pollable() {
        if (this.isCommitted()) {
            return false;
        }
        if (this.lastPolledTimestamp.get() == -1L) {
            return true;
        }
        return this.canRecycle();
    }

    public boolean eagerlyPollable() {
        if (this.isCommitted()) {
            return false;
        }
        return this.lastPolledTimestamp.get() == -1L;
    }

    private boolean canRecycle() {
        return System.currentTimeMillis() - this.lastPolledTimestamp.get() > (long)SubscriptionConfig.getInstance().getSubscriptionRecycleUncommittedEventIntervalMs();
    }

    public void nack() {
        this.response.nack();
        this.lastPolledTimestamp.set(-1L);
        if (this.nackCount.getAndIncrement() > 3L) {
            LOGGER.warn("{} has been nacked {} times", (Object)this, (Object)this.nackCount);
        }
    }

    public void recordLastPolledConsumerId(String consumerId) {
        this.lastPolledConsumerId = consumerId;
    }

    public String getLastPolledConsumerId() {
        return this.lastPolledConsumerId;
    }

    public void prefetchRemainingResponses() {
        this.response.prefetchRemainingResponses();
    }

    public void fetchNextResponse(long offset) throws Exception {
        this.response.fetchNextResponse(offset);
    }

    public void trySerializeRemainingResponses() {
        this.response.trySerializeRemainingResponses();
    }

    public void trySerializeCurrentResponse() {
        this.response.trySerializeCurrentResponse();
    }

    public ByteBuffer getCurrentResponseByteBuffer() throws IOException {
        return this.response.getCurrentResponseByteBuffer();
    }

    public void invalidateCurrentResponseByteBuffer() {
        this.response.invalidateCurrentResponseByteBuffer();
    }

    public int getCurrentResponseSize() throws IOException {
        ByteBuffer byteBuffer = this.getCurrentResponseByteBuffer();
        return byteBuffer.limit() - byteBuffer.position();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getPipeEventCount() {
        return this.pipeEvents.getPipeEventCount();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("commitContext", (Object)this.commitContext).add("response", this.response).add("lastPolledConsumerId", (Object)this.lastPolledConsumerId).add("lastPolledTimestamp", (Object)this.lastPolledTimestamp).add("committedTimestamp", (Object)this.committedTimestamp).add("pipeEvents", (Object)this.pipeEvents).add("rootCommitContext", Objects.nonNull(this.rootCommitContext) ? this.rootCommitContext : "<unknown>").toString();
    }

    @Override
    public int compareTo(SubscriptionEvent that) {
        SubscriptionCommitContext thisCommitContext = Objects.nonNull(this.rootCommitContext) ? this.rootCommitContext : this.commitContext;
        SubscriptionCommitContext thatCommitContext = Objects.nonNull(that.rootCommitContext) ? that.rootCommitContext : that.commitContext;
        return thisCommitContext.compareTo(thatCommitContext);
    }
}

