/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.concurrent.Callable;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;

public abstract class WrappedCallable<V>
implements Callable<V> {
    @Override
    public final V call() {
        try {
            return this.callMayThrow();
        }
        catch (Throwable e) {
            throw ScheduledExecutorUtil.propagate(e);
        }
    }

    public abstract V callMayThrow() throws Throwable;

    public static <V> Callable<V> wrap(final Callable<V> callable) {
        if (callable instanceof WrappedCallable) {
            return callable;
        }
        return new WrappedCallable<V>(){

            @Override
            public V callMayThrow() throws Exception {
                return callable.call();
            }
        };
    }
}

