/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class PooledBinary
implements Comparable<PooledBinary>,
Serializable,
Accountable {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(PooledBinary.class);
    private static final long serialVersionUID = 6394197743397020735L;
    public static final PooledBinary EMPTY_VALUE = new PooledBinary(new byte[0]);
    private Binary binary;
    private int length;
    private int arenaIndex = -1;

    public PooledBinary(byte[] v) {
        this.binary = new Binary(v);
        this.length = this.binary.getLength();
    }

    public PooledBinary(String s, Charset charset) {
        this.binary = new Binary(s, charset);
        this.length = this.binary.getLength();
    }

    public PooledBinary(byte[] v, int length, int arenaIndex) {
        this.binary = new Binary(v);
        this.length = length;
        this.arenaIndex = arenaIndex;
    }

    @Override
    public int compareTo(PooledBinary other) {
        if (other == null) {
            if (this.binary.getValues() == null) {
                return 0;
            }
            return 1;
        }
        int len1 = this.getLength();
        int len2 = other.getLength();
        int lim = Math.min(len1, len2);
        byte[] v0 = this.binary.getValues();
        byte[] v1 = other.binary.getValues();
        for (int k = 0; k < lim; ++k) {
            if (v0[k] == v1[k]) continue;
            return this.getChar(v0, k) - this.getChar(v1, k);
        }
        return len1 - len2;
    }

    private char getChar(byte[] val, int index) {
        return (char)(val[index] & 0xFF);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PooledBinary otherBinary = (PooledBinary)o;
        if (this.length != otherBinary.length) {
            return false;
        }
        byte[] v0 = this.binary.getValues();
        byte[] v1 = otherBinary.binary.getValues();
        for (int i = 0; i < this.length; ++i) {
            if (v0[i] == v1[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.binary.getValues() == null) {
            return 0;
        }
        int result = 1;
        byte[] val = this.binary.getValues();
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + val[i];
        }
        return result;
    }

    public int getLength() {
        return this.length;
    }

    public String getStringValue(Charset charset) {
        return new String(this.binary.getValues(), 0, this.length, charset);
    }

    public String toString() {
        return this.getStringValue(StandardCharsets.UTF_8);
    }

    public byte[] getValues() {
        return this.binary.getValues();
    }

    public void setValues(byte[] values) {
        this.binary.setValues(values);
        this.length = this.binary.getLength();
    }

    public void setValues(byte[] values, int length) {
        this.binary.setValues(values);
        this.length = length;
    }

    public int getArenaIndex() {
        return this.arenaIndex;
    }

    @Override
    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.binary.ramBytesUsed();
    }

    public Binary toBinary() {
        return this.binary;
    }
}

