/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.sqlserver;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.sqlserver.SourceInfo;
import io.debezium.relational.TableId;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class SqlServerSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema = this.commonSchemaBuilder().name("io.debezium.connector.sqlserver.Source").field("schema", Schema.STRING_SCHEMA).field("table", Schema.STRING_SCHEMA).field("change_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("commit_lsn", Schema.OPTIONAL_STRING_SCHEMA).field("event_serial_no", Schema.OPTIONAL_INT64_SCHEMA).build();

    public SqlServerSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        TableId tableId = sourceInfo.getTableId();
        Struct ret = super.commonStruct((AbstractSourceInfo)sourceInfo).put("schema", (Object)(tableId != null ? tableId.schema() : "")).put("table", (Object)(tableId != null ? tableId.table() : ""));
        if (sourceInfo.getChangeLsn() != null && sourceInfo.getChangeLsn().isAvailable()) {
            ret.put("change_lsn", (Object)sourceInfo.getChangeLsn().toString());
        }
        if (sourceInfo.getCommitLsn() != null && sourceInfo.getCommitLsn().isAvailable()) {
            ret.put("commit_lsn", (Object)sourceInfo.getCommitLsn().toString());
        }
        if (sourceInfo.getEventSerialNo() != null) {
            ret.put("event_serial_no", (Object)sourceInfo.getEventSerialNo());
        }
        return ret;
    }
}

