/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.example;

import org.apache.inlong.sdk.dataproxy.MsgSenderFactory;
import org.apache.inlong.sdk.dataproxy.MsgSenderSingleFactory;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.sender.MsgSendCallback;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpEventInfo;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.http.HttpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.sender.http.InLongHttpMsgSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientExample {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientExample.class);

    public static void main(String[] args) {
        String inlongGroupId = "test_group_id";
        String inlongStreamId = "test_stream_id";
        String configBasePath = "";
        String inLongManagerAddr = "127.0.0.1";
        String inLongManagerPort = "8083";
        String messageBody = "inlong message body!";
        MsgSenderSingleFactory senderFactory = new MsgSenderSingleFactory();
        HttpMsgSender sender = HttpClientExample.getMessageSender(senderFactory, false, inLongManagerAddr, inLongManagerPort, inlongGroupId, false, configBasePath);
        HttpClientExample.sendHttpMessage(sender, inlongGroupId, inlongStreamId, messageBody);
        sender.close();
    }

    public static HttpMsgSender getMessageSender(MsgSenderFactory senderFactory, boolean visitMsgByHttps, String managerAddr, String managerPort, String inlongGroupId, boolean useLocalMetaConfig, String configBasePath) {
        InLongHttpMsgSender sender = null;
        try {
            HttpMsgSenderConfig httpConfig = new HttpMsgSenderConfig(visitMsgByHttps, managerAddr, Integer.parseInt(managerPort), inlongGroupId, "admin", "inlong");
            httpConfig.setDiscardHttpCacheWhenClosing(true);
            httpConfig.setMetaStoreBasePath(configBasePath);
            httpConfig.setOnlyUseLocalProxyConfig(useLocalMetaConfig);
            httpConfig.setHttpConTimeoutMs(20000);
            sender = senderFactory.genHttpSenderByGroupId(httpConfig);
        }
        catch (Throwable ex) {
            System.out.println("Get MessageSender throw exception, " + ex);
        }
        return sender;
    }

    public static void sendHttpMessage(HttpMsgSender sender, String inlongGroupId, String inlongStreamId, String messageBody) {
        try {
            ProcessResult procResult = new ProcessResult();
            if (!sender.asyncSendMessage(new HttpEventInfo(inlongGroupId, inlongStreamId, System.currentTimeMillis(), messageBody), new MyMessageCallBack(), procResult)) {
                System.out.println("Send message failure, result = " + procResult);
                return;
            }
            System.out.println("Send message success!");
        }
        catch (Throwable ex) {
            System.out.println("Send message exception" + ex);
        }
    }

    public static class MyMessageCallBack
    implements MsgSendCallback {
        private HttpMsgSender messageSender = null;
        private HttpEventInfo event = null;

        public MyMessageCallBack() {
        }

        public MyMessageCallBack(HttpMsgSender messageSender, HttpEventInfo event) {
            this.messageSender = messageSender;
            this.event = event;
        }

        @Override
        public void onMessageAck(ProcessResult result) {
            if (result.isSuccess()) {
                logger.info("onMessageAck return Ok");
            } else {
                logger.info("onMessageAck return failure = {}", (Object)result);
            }
        }

        @Override
        public void onException(Throwable ex) {
            logger.error("Send message throw exception", ex);
        }
    }
}

