/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.parser;

import java.math.BigDecimal;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.IntervalParser;
import org.apache.inlong.sdk.transform.process.parser.TransformParser;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.apache.inlong.sdk.transform.process.pojo.IntervalInfo;
import org.apache.inlong.sdk.transform.process.utils.DateUtil;

@TransformParser(values={Addition.class})
public class AdditionParser
implements ValueParser {
    private final ValueParser left;
    private final ValueParser right;

    public AdditionParser(Addition expr) {
        this.left = OperatorTools.buildParser(expr.getLeftExpression());
        this.right = OperatorTools.buildParser(expr.getRightExpression());
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.left instanceof IntervalParser && this.right instanceof IntervalParser) {
            return null;
        }
        if (this.left instanceof IntervalParser || this.right instanceof IntervalParser) {
            ValueParser dateParser;
            IntervalParser intervalParser;
            if (this.left instanceof IntervalParser) {
                intervalParser = (IntervalParser)this.left;
                dateParser = this.right;
            } else {
                intervalParser = (IntervalParser)this.right;
                dateParser = this.left;
            }
            Object intervalInfoObj = intervalParser.parse(sourceData, rowIndex, context);
            Object dateObj = dateParser.parse(sourceData, rowIndex, context);
            if (intervalInfoObj == null || dateObj == null) {
                return null;
            }
            return DateUtil.dateTypeAdd(OperatorTools.parseString(dateObj), (IntervalInfo)intervalInfoObj, true);
        }
        return this.numericalOperation(sourceData, rowIndex, context);
    }

    private BigDecimal numericalOperation(SourceData sourceData, int rowIndex, Context context) {
        Object leftObj = this.left.parse(sourceData, rowIndex, context);
        Object rightObj = this.right.parse(sourceData, rowIndex, context);
        if (leftObj == null || rightObj == null) {
            return null;
        }
        BigDecimal leftValue = OperatorTools.parseBigDecimal(leftObj);
        BigDecimal rightValue = OperatorTools.parseBigDecimal(rightObj);
        return leftValue.add(rightValue);
    }
}

