/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.temporal;

import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="temporal", names={"localtime", "current_time"}, parameter="([String timeZoneStr])", descriptions={"- Return the current time in the specified time zone."}, examples={"localTime() = currentTime", "currentTime(\"UTC\") = currentTime"})
public class LocalTimeFunction
implements ValueParser {
    private ValueParser stringParser;

    public LocalTimeFunction(Function expr) {
        if (expr.getParameters() != null) {
            this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        if (this.stringParser != null) {
            String zoneString = OperatorTools.parseString(this.stringParser.parse(sourceData, rowIndex, context));
            return LocalTime.now(ZoneId.of(zoneString)).withNano(0).format(formatter);
        }
        return LocalTime.now(ZoneId.systemDefault()).withNano(0).format(formatter);
    }
}

