/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support;

import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.AttributeBindings;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.MethodCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotation.support.ParameterAttributeNamesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import java.lang.reflect.Method;

public final class SpanAttributesExtractor {
    private final Cache<Method, AttributeBindings> cache;
    private final ParameterAttributeNamesExtractor parameterAttributeNamesExtractor;

    public static SpanAttributesExtractor create(ParameterAttributeNamesExtractor parameterAttributeNamesExtractor) {
        return new SpanAttributesExtractor(parameterAttributeNamesExtractor, new MethodCache<AttributeBindings>());
    }

    SpanAttributesExtractor(ParameterAttributeNamesExtractor parameterAttributeNamesExtractor, Cache<Method, AttributeBindings> cache) {
        this.parameterAttributeNamesExtractor = parameterAttributeNamesExtractor;
        this.cache = cache;
    }

    public Attributes extract(Method method, Object[] args) {
        AttributesBuilder attributes = Attributes.builder();
        AttributeBindings bindings = this.cache.computeIfAbsent(method, m4 -> AttributeBindings.bind(m4, this.parameterAttributeNamesExtractor));
        if (!bindings.isEmpty()) {
            bindings.apply(attributes, args);
        }
        return attributes.build();
    }
}

