/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.message.file;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.agent.message.file.OffsetAckInfo;
import org.apache.inlong.common.msg.InLongMsg;
import org.apache.inlong.common.util.MessageUtils;

public class SenderMessage {
    private String taskId;
    private String instanceId;
    private String groupId;
    private String streamId;
    private List<byte[]> dataList;
    private long dataTime;
    private Map<String, String> extraMap;
    private List<OffsetAckInfo> offsetAckList;

    public InLongMsg getInLongMsg() {
        InLongMsg message = InLongMsg.newInLongMsg((boolean)true);
        String attr = MessageUtils.convertAttrToStr(this.extraMap).toString();
        for (byte[] lineData : this.dataList) {
            message.addMsg(attr, lineData);
        }
        return message;
    }

    public int getMsgCnt() {
        return CollectionUtils.isEmpty(this.dataList) ? 0 : this.dataList.size();
    }

    public long getTotalSize() {
        return CollectionUtils.isEmpty(this.dataList) ? 0L : this.dataList.stream().mapToLong(body -> ((byte[])body).length).sum();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public List<byte[]> getDataList() {
        return this.dataList;
    }

    public long getDataTime() {
        return this.dataTime;
    }

    public Map<String, String> getExtraMap() {
        return this.extraMap;
    }

    public List<OffsetAckInfo> getOffsetAckList() {
        return this.offsetAckList;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public void setDataList(List<byte[]> dataList) {
        this.dataList = dataList;
    }

    public void setDataTime(long dataTime) {
        this.dataTime = dataTime;
    }

    public void setExtraMap(Map<String, String> extraMap) {
        this.extraMap = extraMap;
    }

    public void setOffsetAckList(List<OffsetAckInfo> offsetAckList) {
        this.offsetAckList = offsetAckList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SenderMessage)) {
            return false;
        }
        SenderMessage other = (SenderMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDataTime() != other.getDataTime()) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$instanceId = this.getInstanceId();
        String other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !this$instanceId.equals(other$instanceId)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$streamId = this.getStreamId();
        String other$streamId = other.getStreamId();
        if (this$streamId == null ? other$streamId != null : !this$streamId.equals(other$streamId)) {
            return false;
        }
        List<byte[]> this$dataList = this.getDataList();
        List<byte[]> other$dataList = other.getDataList();
        if (this$dataList == null ? other$dataList != null : !((Object)this$dataList).equals(other$dataList)) {
            return false;
        }
        Map<String, String> this$extraMap = this.getExtraMap();
        Map<String, String> other$extraMap = other.getExtraMap();
        if (this$extraMap == null ? other$extraMap != null : !((Object)this$extraMap).equals(other$extraMap)) {
            return false;
        }
        List<OffsetAckInfo> this$offsetAckList = this.getOffsetAckList();
        List<OffsetAckInfo> other$offsetAckList = other.getOffsetAckList();
        return !(this$offsetAckList == null ? other$offsetAckList != null : !((Object)this$offsetAckList).equals(other$offsetAckList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SenderMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $dataTime = this.getDataTime();
        result = result * 59 + (int)($dataTime >>> 32 ^ $dataTime);
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : $instanceId.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $streamId = this.getStreamId();
        result = result * 59 + ($streamId == null ? 43 : $streamId.hashCode());
        List<byte[]> $dataList = this.getDataList();
        result = result * 59 + ($dataList == null ? 43 : ((Object)$dataList).hashCode());
        Map<String, String> $extraMap = this.getExtraMap();
        result = result * 59 + ($extraMap == null ? 43 : ((Object)$extraMap).hashCode());
        List<OffsetAckInfo> $offsetAckList = this.getOffsetAckList();
        result = result * 59 + ($offsetAckList == null ? 43 : ((Object)$offsetAckList).hashCode());
        return result;
    }

    public String toString() {
        return "SenderMessage(taskId=" + this.getTaskId() + ", instanceId=" + this.getInstanceId() + ", groupId=" + this.getGroupId() + ", streamId=" + this.getStreamId() + ", dataList=" + this.getDataList() + ", dataTime=" + this.getDataTime() + ", extraMap=" + this.getExtraMap() + ", offsetAckList=" + this.getOffsetAckList() + ")";
    }

    public SenderMessage(String taskId, String instanceId, String groupId, String streamId, List<byte[]> dataList, long dataTime, Map<String, String> extraMap, List<OffsetAckInfo> offsetAckList) {
        this.taskId = taskId;
        this.instanceId = instanceId;
        this.groupId = groupId;
        this.streamId = streamId;
        this.dataList = dataList;
        this.dataTime = dataTime;
        this.extraMap = extraMap;
        this.offsetAckList = offsetAckList;
    }

    public SenderMessage() {
    }
}

