/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.TimeZone;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseDateValueParser;

final class ClickHouseInstantParser
extends ClickHouseDateValueParser<Instant> {
    private static ClickHouseInstantParser instance;

    static ClickHouseInstantParser getInstance() {
        if (instance == null) {
            instance = new ClickHouseInstantParser();
        }
        return instance;
    }

    private ClickHouseInstantParser() {
        super(Instant.class);
    }

    @Override
    Instant parseDate(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.parseAsLocalDate(value).atStartOfDay().toInstant(ZoneOffset.UTC);
    }

    @Override
    Instant parseDateTime(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return this.dateTimeToZonedDateTime(value, columnInfo, timeZone).toInstant();
    }

    @Override
    Instant parseNumber(long value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        return value > Integer.MAX_VALUE ? Instant.ofEpochMilli(value) : Instant.ofEpochSecond(value);
    }

    @Override
    Instant parseOther(String value, ClickHouseColumnInfo columnInfo, TimeZone timeZone) {
        try {
            return this.parseAsLocalDate(value).atStartOfDay(this.effectiveTimeZone(columnInfo, timeZone)).toInstant();
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return this.parseAsLocalDateTime(value).atZone(this.effectiveTimeZone(columnInfo, timeZone)).toInstant();
            }
            catch (DateTimeParseException dateTimeParseException2) {
                try {
                    return this.parseAsOffsetDateTime(value).toInstant();
                }
                catch (DateTimeParseException dateTimeParseException3) {
                    return this.parseAsInstant(value);
                }
            }
        }
    }
}

