/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.annotation.Nullable;

public enum PolarisEntityType {
    NULL_TYPE(0, null, false, false),
    ROOT(1, null, false, false),
    PRINCIPAL(2, ROOT, true, false),
    PRINCIPAL_ROLE(3, ROOT, true, false),
    CATALOG(4, ROOT, false, false),
    CATALOG_ROLE(5, CATALOG, true, false),
    NAMESPACE(6, CATALOG, false, true),
    TABLE_LIKE(7, NAMESPACE, false, false),
    TASK(8, ROOT, false, false),
    FILE(9, TABLE_LIKE, false, false),
    POLICY(10, NAMESPACE, false, false);

    private static final PolarisEntityType[] REVERSE_MAPPING_ARRAY;
    private final int code;
    private final boolean isGrantee;
    private final boolean parentSelfReference;
    private final PolarisEntityType parentType;

    private PolarisEntityType(int id, PolarisEntityType parentType, boolean isGrantee, boolean sefRef) {
        this.code = id;
        this.isGrantee = isGrantee;
        this.parentType = parentType;
        this.parentSelfReference = sefRef;
    }

    @JsonValue
    public int getCode() {
        return this.code;
    }

    public boolean isGrantee() {
        return this.isGrantee;
    }

    public boolean isParentSelfReference() {
        return this.parentSelfReference;
    }

    @JsonCreator
    @Nullable
    public static PolarisEntityType fromCode(int entityTypeCode) {
        if (entityTypeCode >= REVERSE_MAPPING_ARRAY.length) {
            return null;
        }
        return REVERSE_MAPPING_ARRAY[entityTypeCode];
    }

    public boolean isTopLevel() {
        return this.parentType == ROOT || this == ROOT;
    }

    public PolarisEntityType getParentType() {
        return this.parentType;
    }

    static {
        int maxId = 0;
        for (PolarisEntityType entityType : PolarisEntityType.values()) {
            if (maxId >= entityType.code) continue;
            maxId = entityType.code;
        }
        REVERSE_MAPPING_ARRAY = new PolarisEntityType[maxId + 1];
        PolarisEntityType[] polarisEntityTypeArray = PolarisEntityType.values();
        int n = polarisEntityTypeArray.length;
        for (int i = 0; i < n; ++i) {
            PolarisEntityType entityType;
            PolarisEntityType.REVERSE_MAPPING_ARRAY[entityType.code] = entityType = polarisEntityTypeArray[i];
        }
    }
}

