/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.credentials.CredentialParser;
import org.apache.iceberg.rest.responses.ImmutableLoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.util.JsonUtil;

public class LoadCredentialsResponseParser {
    private static final String STORAGE_CREDENTIALS = "storage-credentials";

    private LoadCredentialsResponseParser() {
    }

    public static String toJson(LoadCredentialsResponse response) {
        return LoadCredentialsResponseParser.toJson(response, false);
    }

    public static String toJson(LoadCredentialsResponse response, boolean pretty) {
        return JsonUtil.generate(gen -> LoadCredentialsResponseParser.toJson(response, gen), pretty);
    }

    public static void toJson(LoadCredentialsResponse response, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != response ? 1 : 0) != 0, (Object)"Invalid load credentials response: null");
        gen.writeStartObject();
        gen.writeArrayFieldStart(STORAGE_CREDENTIALS);
        for (Credential credential : response.credentials()) {
            CredentialParser.toJson(credential, gen);
        }
        gen.writeEndArray();
        gen.writeEndObject();
    }

    public static LoadCredentialsResponse fromJson(String json) {
        return JsonUtil.parse(json, LoadCredentialsResponseParser::fromJson);
    }

    public static LoadCredentialsResponse fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse load credentials response from null object");
        JsonNode credentials = JsonUtil.get(STORAGE_CREDENTIALS, json);
        Preconditions.checkArgument((boolean)credentials.isArray(), (String)"Cannot parse credentials from non-array: %s", (Object)credentials);
        ImmutableLoadCredentialsResponse.Builder builder = ImmutableLoadCredentialsResponse.builder();
        for (JsonNode credential : credentials) {
            builder.addCredentials(CredentialParser.fromJson(credential));
        }
        return builder.build();
    }
}

