/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.scope.refresh;

import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import java.util.Set;

public interface RefreshEventListener
extends ApplicationEventListener<RefreshEvent>,
Ordered {
    public static final int DEFAULT_POSITION = -2147483448;

    default public boolean supports(RefreshEvent event) {
        Object source;
        if (event != null && (source = event.getSource()) != null) {
            if (source == RefreshEvent.ALL_KEYS) {
                return true;
            }
            Set keys = source.keySet();
            Set<String> prefixes = this.getObservedConfigurationPrefixes();
            if (CollectionUtils.isNotEmpty(prefixes)) {
                for (String prefix : prefixes) {
                    if (!keys.stream().anyMatch(k -> k.startsWith(prefix))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @NonNull
    public Set<String> getObservedConfigurationPrefixes();

    default public int getOrder() {
        return -2147483448;
    }
}

