/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.schema.lookup.Named;
import org.checkerframework.checker.nullness.qual.Nullable;

class ConcatLookup<T>
implements Lookup<T> {
    private final Lookup<T>[] lookups;

    ConcatLookup(Lookup<T>[] lookups) {
        this.lookups = lookups;
    }

    @Override
    public @Nullable T get(String name) {
        for (Lookup<T> lookup : this.lookups) {
            T t = lookup.get(name);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public @Nullable Named<T> getIgnoreCase(String name) {
        for (Lookup<T> lookup : this.lookups) {
            Named<T> t = lookup.getIgnoreCase(name);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public Set<String> getNames(LikePattern pattern) {
        return Stream.of(this.lookups).flatMap(lookup -> lookup.getNames(pattern).stream()).collect(Collectors.toSet());
    }
}

