/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.concurrent;

import java.time.Duration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.concurrent.FutureCallbackAdapter;
import org.apache.hc.core5.util.TimeoutValueException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestBasicFuture {
    TestBasicFuture() {
    }

    @Test
    void testCompleted() throws Exception {
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        BasicFuture future = new BasicFuture(callback);
        Assertions.assertFalse((boolean)future.isDone());
        Object result = new Object();
        Exception boom = new Exception();
        future.completed(result);
        future.failed(boom);
        ((FutureCallback)Mockito.verify((Object)callback)).completed(result);
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).failed((Exception)ArgumentMatchers.any());
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).cancelled();
        Assertions.assertSame((Object)result, (Object)future.get());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
    }

    @Test
    void testCompletedWithTimeout() throws Exception {
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        BasicFuture future = new BasicFuture(callback);
        Assertions.assertFalse((boolean)future.isDone());
        Object result = new Object();
        Exception boom = new Exception();
        future.completed(result);
        future.failed(boom);
        ((FutureCallback)Mockito.verify((Object)callback)).completed(result);
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).failed((Exception)ArgumentMatchers.any());
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).cancelled();
        Assertions.assertSame((Object)result, (Object)future.get(1L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
    }

    @Test
    void testFailed() throws Exception {
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        BasicFuture future = new BasicFuture(callback);
        Object result = new Object();
        Exception boom = new Exception();
        future.failed(boom);
        future.completed(result);
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).completed(ArgumentMatchers.any());
        ((FutureCallback)Mockito.verify((Object)callback)).failed(boom);
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).cancelled();
        try {
            future.get();
        }
        catch (ExecutionException ex) {
            Assertions.assertSame((Object)boom, (Object)ex.getCause());
        }
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
    }

    @Test
    void testCancelled() {
        FutureCallback callback = (FutureCallback)Mockito.mock(FutureCallback.class);
        BasicFuture future = new BasicFuture(callback);
        Object result = new Object();
        Exception boom = new Exception();
        future.cancel(true);
        future.failed(boom);
        future.completed(result);
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).completed(ArgumentMatchers.any());
        ((FutureCallback)Mockito.verify((Object)callback, (VerificationMode)Mockito.never())).failed((Exception)ArgumentMatchers.any());
        ((FutureCallback)Mockito.verify((Object)callback)).cancelled();
        Assertions.assertThrows(CancellationException.class, () -> ((BasicFuture)future).get());
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertTrue((boolean)future.isCancelled());
    }

    @Test
    void testAsyncCompleted() throws Exception {
        BasicFuture future = new BasicFuture(null);
        Object result = new Object();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(100L);
                future.completed(result);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        t.setDaemon(true);
        t.start();
        Assertions.assertSame((Object)result, (Object)future.get(60L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
    }

    @Test
    void testAsyncFailed() throws Exception {
        BasicFuture future = new BasicFuture(null);
        Exception boom = new Exception();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(100L);
                future.failed(boom);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        t.setDaemon(true);
        t.start();
        try {
            future.get(60L, TimeUnit.SECONDS);
        }
        catch (ExecutionException ex) {
            Assertions.assertSame((Object)boom, (Object)ex.getCause());
        }
        Assertions.assertTrue((boolean)future.isDone());
        Assertions.assertFalse((boolean)future.isCancelled());
    }

    @Test
    void testAsyncCancelled() {
        BasicFuture future = new BasicFuture(null);
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(100L);
                future.cancel(true);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        t.setDaemon(true);
        t.start();
        Assertions.assertThrows(CancellationException.class, () -> future.get(60L, TimeUnit.SECONDS));
    }

    @Test
    void testAsyncTimeout() {
        BasicFuture future = new BasicFuture(null);
        Object result = new Object();
        Thread t = new Thread(() -> {
            try {
                Thread.sleep(200L);
                future.completed(result);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        t.setDaemon(true);
        t.start();
        Assertions.assertThrows(TimeoutException.class, () -> future.get(1L, TimeUnit.MILLISECONDS));
    }

    @Test
    void testAsyncNegativeTimeout() {
        BasicFuture future = new BasicFuture(null);
        Assertions.assertThrows(TimeoutValueException.class, () -> future.get(-1L, TimeUnit.MILLISECONDS));
    }

    @Test
    void testConcurrentOperations() throws InterruptedException, ExecutionException {
        FutureCallbackAdapter callback = FutureCallbackAdapter.getInstance();
        ExecutorService executor = Executors.newFixedThreadPool(3);
        BasicFuture future = new BasicFuture(callback);
        Object expectedResult = new Object();
        AtomicBoolean completedSuccessfully = new AtomicBoolean();
        AtomicBoolean failedSuccessfully = new AtomicBoolean();
        AtomicBoolean cancelledSuccessfully = new AtomicBoolean();
        Future<?> future1 = executor.submit(() -> completedSuccessfully.set(future.completed(expectedResult)));
        Future<?> future2 = executor.submit(() -> failedSuccessfully.set(future.failed(new Exception("Test Exception"))));
        Future<?> future3 = executor.submit(() -> cancelledSuccessfully.set(future.cancel()));
        future1.get();
        future2.get();
        future3.get();
        if (completedSuccessfully.get()) {
            Assertions.assertEquals((Object)expectedResult, (Object)future.get());
        } else if (failedSuccessfully.get()) {
            Assertions.assertThrows(ExecutionException.class, () -> ((BasicFuture)future).get());
        } else if (cancelledSuccessfully.get()) {
            Assertions.assertThrows(CancellationException.class, () -> ((BasicFuture)future).get());
        } else {
            Assertions.fail((String)"No operation was successful on the future.");
        }
        executor.shutdown();
    }

    @Test
    void testGetWithTimeout() {
        final AtomicBoolean isFutureCompleted = new AtomicBoolean();
        FutureCallbackAdapter<String> callback = new FutureCallbackAdapter<String>(){

            @Override
            public void completed(String result) {
                isFutureCompleted.set(true);
            }
        };
        BasicFuture future = new BasicFuture((FutureCallback)callback);
        new Thread(() -> future.completed((Object)"test")).start();
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(200L), () -> {
            while (!isFutureCompleted.get()) {
                Thread.yield();
            }
            try {
                Assertions.assertEquals((Object)"test", (Object)future.get(1L, TimeUnit.SECONDS));
            }
            catch (ExecutionException | TimeoutException e) {
                Assertions.fail((String)("Test failed due to exception: " + e.getMessage()));
            }
        });
    }
}

