/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.reactor;

import java.net.UnknownHostException;
import java.util.concurrent.Future;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.AbstractIOSessionPool;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

class TestAbstractIOSessionPool {
    @Mock
    private Future<IOSession> connectFuture;
    @Mock
    private FutureCallback<IOSession> callback1;
    @Mock
    private FutureCallback<IOSession> callback2;
    @Mock
    private IOSession ioSession1;
    @Mock
    private IOSession ioSession2;
    @Captor
    ArgumentCaptor<FutureCallback<IOSession>> connectCallbackCaptor;
    private AbstractIOSessionPool<String> impl;

    TestAbstractIOSessionPool() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks((Object)this);
        this.impl = (AbstractIOSessionPool)Mockito.mock(AbstractIOSessionPool.class, (MockSettings)Mockito.withSettings().defaultAnswer((Answer)Answers.CALLS_REAL_METHODS).useConstructor(new Object[0]));
    }

    @Test
    void testGetSessions() throws Exception {
        Mockito.when((Object)this.impl.connectSession((Object)ArgumentMatchers.anyString(), (Timeout)ArgumentMatchers.any(), (FutureCallback)ArgumentMatchers.any())).thenReturn(this.connectFuture);
        ((AbstractIOSessionPool)Mockito.doAnswer(invocation -> {
            Callback callback = (Callback)invocation.getArgument(1);
            callback.execute((Object)true);
            return null;
        }).when(this.impl)).validateSession((IOSession)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        Mockito.when((Object)this.ioSession1.isOpen()).thenReturn((Object)true);
        Future future1 = this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        MatcherAssert.assertThat((Object)future1, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)future1.isDone(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.impl.getRoutes(), (Matcher)CoreMatchers.hasItem((Object)"somehost"));
        ((AbstractIOSessionPool)Mockito.verify(this.impl)).connectSession(ArgumentMatchers.eq((Object)"somehost"), (Timeout)ArgumentMatchers.eq((Object)Timeout.ofSeconds((long)123L)), (FutureCallback)ArgumentMatchers.any());
        Future future2 = this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        MatcherAssert.assertThat((Object)future2, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)future2.isDone(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.impl.getRoutes(), (Matcher)CoreMatchers.hasItem((Object)"somehost"));
        ((AbstractIOSessionPool)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)1))).connectSession(ArgumentMatchers.eq((Object)"somehost"), (Timeout)ArgumentMatchers.any(), (FutureCallback)ArgumentMatchers.argThat(callback -> {
            callback.completed((Object)this.ioSession1);
            return true;
        }));
        MatcherAssert.assertThat((Object)future1.isDone(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat(future1.get(), (Matcher)CoreMatchers.sameInstance((Object)this.ioSession1));
        MatcherAssert.assertThat((Object)future2.isDone(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat(future2.get(), (Matcher)CoreMatchers.sameInstance((Object)this.ioSession1));
        ((AbstractIOSessionPool)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)2))).validateSession((IOSession)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        Future future3 = this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        ((AbstractIOSessionPool)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)1))).connectSession(ArgumentMatchers.eq((Object)"somehost"), (Timeout)ArgumentMatchers.any(), (FutureCallback)ArgumentMatchers.any());
        ((AbstractIOSessionPool)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)3))).validateSession((IOSession)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        MatcherAssert.assertThat((Object)future3.isDone(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat(future3.get(), (Matcher)CoreMatchers.sameInstance((Object)this.ioSession1));
    }

    @Test
    void testGetSessionConnectFailure() {
        Mockito.when((Object)this.impl.connectSession((Object)ArgumentMatchers.anyString(), (Timeout)ArgumentMatchers.any(), (FutureCallback)ArgumentMatchers.any())).thenReturn(this.connectFuture);
        Future future1 = this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        MatcherAssert.assertThat((Object)future1, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)future1.isDone(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.impl.getRoutes(), (Matcher)CoreMatchers.hasItem((Object)"somehost"));
        ((AbstractIOSessionPool)Mockito.verify(this.impl)).connectSession(ArgumentMatchers.eq((Object)"somehost"), (Timeout)ArgumentMatchers.eq((Object)Timeout.ofSeconds((long)123L)), (FutureCallback)this.connectCallbackCaptor.capture());
        Future future2 = this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        MatcherAssert.assertThat((Object)future2, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)future2.isDone(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.impl.getRoutes(), (Matcher)CoreMatchers.hasItem((Object)"somehost"));
        FutureCallback connectCallback = (FutureCallback)this.connectCallbackCaptor.getValue();
        Assertions.assertNotNull((Object)connectCallback);
        connectCallback.failed(new Exception("Boom"));
        MatcherAssert.assertThat((Object)future1.isDone(), (Matcher)CoreMatchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)future2.isDone(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    void testShutdownPool() {
        AbstractIOSessionPool.PoolEntry entry1 = this.impl.getPoolEntry((Object)"host1");
        MatcherAssert.assertThat((Object)entry1, (Matcher)CoreMatchers.notNullValue());
        entry1.session = this.ioSession1;
        AbstractIOSessionPool.PoolEntry entry2 = this.impl.getPoolEntry((Object)"host2");
        MatcherAssert.assertThat((Object)entry2, (Matcher)CoreMatchers.notNullValue());
        entry2.session = this.ioSession2;
        AbstractIOSessionPool.PoolEntry entry3 = this.impl.getPoolEntry((Object)"host3");
        MatcherAssert.assertThat((Object)entry3, (Matcher)CoreMatchers.notNullValue());
        entry3.sessionFuture = this.connectFuture;
        entry3.requestQueue.add(this.callback1);
        entry3.requestQueue.add(this.callback2);
        this.impl.close(CloseMode.GRACEFUL);
        ((AbstractIOSessionPool)Mockito.verify(this.impl)).closeSession(this.ioSession1, CloseMode.GRACEFUL);
        ((AbstractIOSessionPool)Mockito.verify(this.impl)).closeSession(this.ioSession2, CloseMode.GRACEFUL);
        ((Future)Mockito.verify(this.connectFuture)).cancel(ArgumentMatchers.anyBoolean());
        ((FutureCallback)Mockito.verify(this.callback1)).cancelled();
        ((FutureCallback)Mockito.verify(this.callback2)).cancelled();
    }

    @Test
    void testCloseIdleSessions() {
        AbstractIOSessionPool.PoolEntry entry1 = this.impl.getPoolEntry((Object)"host1");
        MatcherAssert.assertThat((Object)entry1, (Matcher)CoreMatchers.notNullValue());
        entry1.session = this.ioSession1;
        AbstractIOSessionPool.PoolEntry entry2 = this.impl.getPoolEntry((Object)"host2");
        MatcherAssert.assertThat((Object)entry2, (Matcher)CoreMatchers.notNullValue());
        entry2.session = this.ioSession2;
        this.impl.closeIdle(TimeValue.ZERO_MILLISECONDS);
        ((AbstractIOSessionPool)Mockito.verify(this.impl)).closeSession(this.ioSession1, CloseMode.GRACEFUL);
        ((AbstractIOSessionPool)Mockito.verify(this.impl)).closeSession(this.ioSession2, CloseMode.GRACEFUL);
        MatcherAssert.assertThat((Object)entry1.session, (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)entry2.session, (Matcher)CoreMatchers.nullValue());
    }

    @Test
    void testEnumSessions() {
        AbstractIOSessionPool.PoolEntry entry1 = this.impl.getPoolEntry((Object)"host1");
        MatcherAssert.assertThat((Object)entry1, (Matcher)CoreMatchers.notNullValue());
        entry1.session = this.ioSession1;
        AbstractIOSessionPool.PoolEntry entry2 = this.impl.getPoolEntry((Object)"host2");
        MatcherAssert.assertThat((Object)entry2, (Matcher)CoreMatchers.notNullValue());
        entry2.session = this.ioSession2;
        this.impl.enumAvailable(ioSession -> ioSession.close(CloseMode.GRACEFUL));
        ((IOSession)Mockito.verify((Object)this.ioSession1)).close(CloseMode.GRACEFUL);
        ((IOSession)Mockito.verify((Object)this.ioSession2)).close(CloseMode.GRACEFUL);
    }

    @Test
    void testGetSessionReconnectAfterValidate() {
        AbstractIOSessionPool.PoolEntry entry1 = this.impl.getPoolEntry((Object)"somehost");
        MatcherAssert.assertThat((Object)entry1, (Matcher)CoreMatchers.notNullValue());
        entry1.session = this.ioSession1;
        Mockito.when((Object)this.ioSession1.isOpen()).thenReturn((Object)true);
        ((AbstractIOSessionPool)Mockito.doAnswer(invocation -> {
            Callback callback = (Callback)invocation.getArgument(1);
            callback.execute((Object)false);
            return null;
        }).when(this.impl)).validateSession((IOSession)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        ((AbstractIOSessionPool)Mockito.verify(this.impl, (VerificationMode)Mockito.times((int)1))).connectSession(ArgumentMatchers.eq((Object)"somehost"), (Timeout)ArgumentMatchers.eq((Object)Timeout.ofSeconds((long)123L)), (FutureCallback)ArgumentMatchers.any());
    }

    @Test
    void testGetSessionReconnectIfClosed() {
        AbstractIOSessionPool.PoolEntry entry1 = this.impl.getPoolEntry((Object)"somehost");
        MatcherAssert.assertThat((Object)entry1, (Matcher)CoreMatchers.notNullValue());
        entry1.session = this.ioSession1;
        Mockito.when((Object)this.ioSession1.isOpen()).thenReturn((Object)false);
        this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        ((AbstractIOSessionPool)Mockito.verify(this.impl)).connectSession(ArgumentMatchers.eq((Object)"somehost"), (Timeout)ArgumentMatchers.eq((Object)Timeout.ofSeconds((long)123L)), (FutureCallback)ArgumentMatchers.any());
    }

    @Test
    void testGetSessionConnectUnknownHost() {
        Mockito.when((Object)this.connectFuture.isDone()).thenReturn((Object)true);
        Mockito.when((Object)this.impl.connectSession((Object)ArgumentMatchers.anyString(), (Timeout)ArgumentMatchers.any(), (FutureCallback)ArgumentMatchers.argThat(callback -> {
            callback.failed((Exception)new UnknownHostException("Boom"));
            return true;
        }))).thenReturn(this.connectFuture);
        Future future1 = this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        MatcherAssert.assertThat((Object)future1, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)future1.isDone(), (Matcher)CoreMatchers.equalTo((Object)true));
        Future future2 = this.impl.getSession((Object)"somehost", Timeout.ofSeconds((long)123L), null);
        MatcherAssert.assertThat((Object)future2, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)future2.isDone(), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

