/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.documentation;

import java.util.List;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.documentation.DocBuilder;
import org.apache.hop.documentation.Toc;
import org.apache.hop.documentation.TocEntry;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;

public class MetadataDelegate {
    public static final String METADATA_FOLDER = "metadata";
    public static final String TOP_METADATA_FILENAME = "index.md";
    private final DocBuilder docBuilder;

    MetadataDelegate(DocBuilder docBuilder) {
        this.docBuilder = docBuilder;
    }

    public void documentMetadata(Toc toc, FileObject targetRootFolder) throws Exception {
        MultiMetadataProvider multiMetadataProvider = this.docBuilder.getMetadataProvider();
        this.docBuilder.getLog().logBasic("Documenting metadata in folder metadata");
        FileObject metadataFolder = targetRootFolder.resolveFile(METADATA_FOLDER);
        if (!metadataFolder.exists()) {
            metadataFolder.createFolder();
        }
        StringBuilder topMetaPage = new StringBuilder();
        topMetaPage.append("---").append(Const.CR).append("title: Hop Metadata  ").append(Const.CR).append("---").append(Const.CR).append(Const.CR);
        topMetaPage.append("# Hop Metadata  ").append(Const.CR).append(Const.CR);
        topMetaPage.append("## Sources  ").append(Const.CR);
        for (Object metadataProvider : multiMetadataProvider.getProviders()) {
            topMetaPage.append("- provider: ").append(metadataProvider.getDescription()).append("  ").append(Const.CR);
        }
        topMetaPage.append("## Elements  ").append(Const.CR);
        List metadataClasses = multiMetadataProvider.getMetadataClasses();
        for (Class metadataClass : metadataClasses) {
            IHopMetadataSerializer serializer = multiMetadataProvider.getSerializer(metadataClass);
            List names = serializer.listObjectNames();
            if (names.isEmpty()) continue;
            topMetaPage.append("### ").append(serializer.getDescription()).append("  ").append(Const.CR);
            for (String name : names) {
                topMetaPage.append("* ").append(name).append("  ").append(Const.CR);
            }
            topMetaPage.append(Const.CR);
        }
        String topMetaFilename = String.valueOf(metadataFolder) + "/index.md";
        this.docBuilder.saveFile(topMetaFilename, topMetaPage.toString());
        toc.getEntries().add(new TocEntry(".", "Metadata", "Overview", "", "metadata/index.md"));
    }

    @Generated
    public DocBuilder getDocBuilder() {
        return this.docBuilder;
    }
}

