/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.leader;

import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.leader.LeaderElection;

public class CMClearer
implements LeaderElection.LeadershipStateListener {
    private final Configuration configuration;
    private ScheduledExecutorService executor;

    public CMClearer(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration is null");
    }

    @Override
    public void takeLeadership(LeaderElection election) throws Exception {
        if (!MetastoreConf.getBoolVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.REPLCMENABLED)) {
            return;
        }
        if (this.executor != null) {
            throw new IllegalStateException("There should be no running tasks");
        }
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("cmclearer-%d").daemon(true).build());
        this.executor.scheduleAtFixedRate((Runnable)new ReplChangeManager.CMClearer(MetastoreConf.getTimeVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.REPLCMRETIAN, (TimeUnit)TimeUnit.SECONDS), this.configuration), 0L, MetastoreConf.getTimeVar((Configuration)this.configuration, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.REPLCMINTERVAL, (TimeUnit)TimeUnit.SECONDS), TimeUnit.SECONDS);
    }

    @Override
    public void lossLeadership(LeaderElection election) throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

