/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.auth.oauth2;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenIntrospectionRequest;
import com.nimbusds.oauth2.sdk.TokenIntrospectionResponse;
import com.nimbusds.oauth2.sdk.TokenIntrospectionSuccessResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.BearerTokenError;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.token.TokenSchemeError;
import java.io.IOException;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.List;
import org.apache.hadoop.hive.metastore.auth.HttpAuthenticationException;
import org.apache.hadoop.hive.metastore.auth.oauth2.OAuth2Authenticator;
import org.apache.hadoop.hive.metastore.auth.oauth2.OAuth2PrincipalMapper;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public class TokenIntrospectionAuthenticator
implements OAuth2Authenticator {
    private final URI introspectionEndpoint;
    private final Audience audience;
    private final ClientAuthentication credential;
    private final OAuth2PrincipalMapper principalMapper;
    private final Cache<String, TokenIntrospectionSuccessResponse> cache;

    public TokenIntrospectionAuthenticator(URI introspectionEndpoint, Audience audience, ClientAuthentication credential, OAuth2PrincipalMapper principalMapper, Duration maxCacheDuration, long cacheSize) {
        this.introspectionEndpoint = introspectionEndpoint;
        this.audience = audience;
        this.credential = credential;
        this.principalMapper = principalMapper;
        this.cache = maxCacheDuration.isPositive() ? Caffeine.newBuilder().maximumSize(cacheSize).expireAfter((Expiry)new TokenExpiry(maxCacheDuration, Clock.systemUTC())).build() : null;
    }

    @Override
    public String resolveUserName(String bearerToken, List<String> requiredScopes) throws HttpAuthenticationException {
        OAuth2Authenticator.requireBearerToken(bearerToken);
        TokenIntrospectionSuccessResponse result = this.cache == null ? this.postIntrospection(bearerToken) : this.postIntrospectionWithCache(bearerToken);
        OAuth2Authenticator.requireScopes(result.getScope(), requiredScopes);
        return this.principalMapper.getUserName(arg_0 -> ((TokenIntrospectionSuccessResponse)result).getStringParameter(arg_0));
    }

    private TokenIntrospectionSuccessResponse postIntrospectionWithCache(String bearerToken) throws HttpAuthenticationException {
        try {
            return (TokenIntrospectionSuccessResponse)this.cache.get((Object)bearerToken, token -> {
                try {
                    return this.postIntrospection(bearerToken);
                }
                catch (HttpAuthenticationException e) {
                    throw new UncheckedException(e);
                }
            });
        }
        catch (UncheckedException e) {
            throw e.underlying;
        }
    }

    private TokenIntrospectionSuccessResponse postIntrospection(String bearerToken) throws HttpAuthenticationException {
        TokenIntrospectionResponse response;
        HTTPResponse httpResponse;
        TokenIntrospectionRequest request = new TokenIntrospectionRequest(this.introspectionEndpoint, this.credential, (Token)new BearerAccessToken(bearerToken));
        try {
            httpResponse = request.toHTTPRequest().send();
        }
        catch (IOException e) {
            throw new HttpAuthenticationException("The authorization server is unavailable", e, 500);
        }
        try {
            response = TokenIntrospectionResponse.parse((HTTPResponse)httpResponse);
        }
        catch (ParseException e) {
            throw new HttpAuthenticationException("Received an invalid response from the authorization server", e, 500);
        }
        if (!response.indicatesSuccess()) {
            String string;
            ErrorObject error = response.toErrorResponse().getErrorObject();
            if (error instanceof TokenSchemeError) {
                TokenSchemeError tokenSchemeError = (TokenSchemeError)error;
                string = tokenSchemeError.toWWWAuthenticateHeader();
            } else {
                string = null;
            }
            String wwwAuthenticateHeader = string;
            throw new HttpAuthenticationException("Failed to introspect the token", error.getHTTPStatusCode(), wwwAuthenticateHeader);
        }
        TokenIntrospectionSuccessResponse result = response.toSuccessResponse();
        if (!result.isActive()) {
            BearerTokenError error = BearerTokenError.INVALID_TOKEN;
            throw new HttpAuthenticationException("The token is not active", error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
        if (result.getAudience() == null || !result.getAudience().contains(this.audience)) {
            BearerTokenError error = BearerTokenError.INVALID_TOKEN;
            throw new HttpAuthenticationException("The aud is invalid: " + String.valueOf(result.getAudience()), error.getHTTPStatusCode(), error.toWWWAuthenticateHeader());
        }
        return result;
    }

    private record TokenExpiry(Duration maxExpiration, Clock clock) implements Expiry<String, TokenIntrospectionSuccessResponse>
    {
        public long expireAfterCreate(@NonNull String key, @NonNull TokenIntrospectionSuccessResponse value, long currentTime) {
            Duration expiresIn = Duration.between(value.getExpirationTime().toInstant(), this.clock.instant());
            return Math.min(expiresIn.toNanos(), this.maxExpiration.toNanos());
        }

        public long expireAfterUpdate(@NonNull String key, @NonNull TokenIntrospectionSuccessResponse value, long currentTime, @NonNegative long currentDuration) {
            Duration expiresIn = Duration.between(value.getExpirationTime().toInstant(), this.clock.instant());
            return Math.min(expiresIn.toNanos(), this.maxExpiration.toNanos());
        }

        public long expireAfterRead(@NonNull String key, @NonNull TokenIntrospectionSuccessResponse value, long currentTime, @NonNegative long currentDuration) {
            return currentDuration;
        }
    }

    private static final class UncheckedException
    extends RuntimeException {
        private final HttpAuthenticationException underlying;

        private UncheckedException(HttpAuthenticationException cause) {
            this.underlying = cause;
        }
    }
}

