/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.TableScan;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.CteRuleConfig;

public class RemoveInfrequentCteRule
extends RelRule<CteRuleConfig> {
    public RemoveInfrequentCteRule(CteRuleConfig config) {
        super((RelRule.Config)config);
        if (config.referenceThreshold() <= 0) {
            throw new IllegalArgumentException("Invalid reference threshold:" + config.referenceThreshold());
        }
    }

    public boolean matches(RelOptRuleCall call) {
        TableScan scan = (TableScan)call.rel(0);
        return ((CteRuleConfig)this.config).getTableOccurrences().getOrDefault(scan.getTable().getQualifiedName(), 0) <= ((CteRuleConfig)this.config).referenceThreshold();
    }

    public void onMatch(RelOptRuleCall call) {
        TableScan scan = (TableScan)call.rel(0);
        String tableName = scan.getTable().getQualifiedName().toString();
        for (RelOptMaterialization cte : call.getPlanner().getMaterializations()) {
            if (!tableName.equals(cte.qualifiedTableName.toString())) continue;
            call.transformTo(cte.queryRel);
        }
    }
}

