/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lib;

import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class DefaultRuleDispatcher
implements SemanticDispatcher {
    private final Map<SemanticRule, SemanticNodeProcessor> procRules;
    private final NodeProcessorCtx procCtx;
    private final SemanticNodeProcessor defaultProc;

    public DefaultRuleDispatcher(SemanticNodeProcessor defaultProc, Map<SemanticRule, SemanticNodeProcessor> rules, NodeProcessorCtx procCtx) {
        this.defaultProc = defaultProc;
        this.procRules = rules;
        this.procCtx = procCtx;
    }

    @Override
    public Object dispatch(Node nd, Stack<Node> ndStack, Object ... nodeOutputs) throws SemanticException {
        SemanticRule rule = null;
        int minCost = Integer.MAX_VALUE;
        for (SemanticRule r : this.procRules.keySet()) {
            int cost = r.cost(ndStack);
            if (cost < 0 || cost > minCost) continue;
            minCost = cost;
            rule = r;
        }
        SemanticNodeProcessor proc = rule == null ? this.defaultProc : this.procRules.get(rule);
        if (proc != null) {
            return proc.process(nd, ndStack, this.procCtx, nodeOutputs);
        }
        return null;
    }
}

