/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import org.apache.hadoop.conf.Configuration;

public class PositionDeleteInfo {
    private static final String CONF_KEY_SPEC_ID = "hive.io.context.position.delete.spec.id";
    private static final String CONF_KEY_PART_HASH = "hive.io.context.position.delete.partition.hash";
    private static final String CONF_KEY_FILE_PATH = "hive.io.context.position.delete.file.path";
    private static final String CONF_KEY_ROW_POSITION = "hive.io.context.position.delete.row.position";
    private static final String CONF_KEY_PARTITION_PROJECTION = "hive.io.context.position.delete.partition.projection";
    private final int specId;
    private final long partitionHash;
    private final String filePath;
    private final long filePos;
    private final String partitionProjection;

    public static PositionDeleteInfo parseFromConf(Configuration conf) {
        int specId = conf.getInt(CONF_KEY_SPEC_ID, -1);
        long partHash = conf.getLong(CONF_KEY_PART_HASH, -1L);
        String filePath = conf.get(CONF_KEY_FILE_PATH);
        long rowPos = conf.getLong(CONF_KEY_ROW_POSITION, -1L);
        String partitionProjection = conf.get(CONF_KEY_PARTITION_PROJECTION);
        return new PositionDeleteInfo(specId, partHash, filePath, rowPos, partitionProjection);
    }

    public static void setIntoConf(Configuration conf, int specId, long partHash, String filePath, long filePos, String partitionProjection) {
        conf.setInt(CONF_KEY_SPEC_ID, specId);
        conf.setLong(CONF_KEY_PART_HASH, partHash);
        conf.set(CONF_KEY_FILE_PATH, filePath);
        conf.setLong(CONF_KEY_ROW_POSITION, filePos);
        conf.set(CONF_KEY_PARTITION_PROJECTION, partitionProjection);
    }

    public PositionDeleteInfo(int specId, long partitionHash, String filePath, long filePos, String partitionProjection) {
        this.specId = specId;
        this.partitionHash = partitionHash;
        this.filePath = filePath;
        this.filePos = filePos;
        this.partitionProjection = partitionProjection;
    }

    public int getSpecId() {
        return this.specId;
    }

    public long getPartitionHash() {
        return this.partitionHash;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public long getFilePos() {
        return this.filePos;
    }

    public String getPartitionProjection() {
        return this.partitionProjection;
    }
}

