/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.cli.command.AbstractCommand;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.options.OptionHelp;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.cli.util.Log;

public class HintCommand
extends AbstractCommand {
    private final CommandRunner commandRunner;

    public HintCommand(CommandRunner commandRunner) {
        super("hint", "Provides hints for shell auto-completion");
        this.commandRunner = commandRunner;
    }

    @Override
    public ExitStatus run(String ... args) throws Exception {
        try {
            int index2 = args.length != 0 ? Integer.parseInt(args[0]) - 1 : 0;
            ArrayList<String> arguments = new ArrayList<String>(args.length);
            for (int i2 = 2; i2 < args.length; ++i2) {
                arguments.add(args[i2]);
            }
            String starting = "";
            if (index2 < arguments.size()) {
                starting = (String)arguments.remove(index2);
            }
            if (index2 == 0) {
                this.showCommandHints(starting);
            } else if (!arguments.isEmpty() && !starting.isEmpty()) {
                String command = (String)arguments.remove(0);
                this.showCommandOptionHints(command, Collections.unmodifiableList(arguments), starting);
            }
        }
        catch (Exception ex) {
            return ExitStatus.ERROR;
        }
        return ExitStatus.OK;
    }

    private void showCommandHints(String starting) {
        for (Command command : this.commandRunner) {
            if (!this.isHintMatch(command, starting)) continue;
            Log.info(command.getName() + " " + command.getDescription());
        }
    }

    private boolean isHintMatch(Command command, String starting) {
        if (command instanceof HintCommand) {
            return false;
        }
        return command.getName().startsWith(starting) || this.commandRunner.isOptionCommand(command) && ("--" + command.getName()).startsWith(starting);
    }

    private void showCommandOptionHints(String commandName, List<String> specifiedArguments, String starting) {
        Command command = this.commandRunner.findCommand(commandName);
        if (command != null) {
            for (OptionHelp help : command.getOptionsHelp()) {
                if (this.alreadyUsed(help, specifiedArguments)) continue;
                for (String option : help.getOptions()) {
                    if (!option.startsWith(starting)) continue;
                    Log.info(option + " " + help.getUsageHelp());
                }
            }
        }
    }

    private boolean alreadyUsed(OptionHelp help, List<String> specifiedArguments) {
        for (String argument : specifiedArguments) {
            if (!help.getOptions().contains(argument)) continue;
            return true;
        }
        return false;
    }
}

