/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded;

import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.VirtualThreadPool;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

public class JettyVirtualThreadsWebServerFactoryCustomizer
implements WebServerFactoryCustomizer<ConfigurableJettyWebServerFactory>,
Ordered {
    private final ServerProperties serverProperties;

    public JettyVirtualThreadsWebServerFactoryCustomizer(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    @Override
    public void customize(ConfigurableJettyWebServerFactory factory) {
        Assert.state(VirtualThreads.areSupported(), "Virtual threads are not supported");
        VirtualThreadPool virtualThreadPool = new VirtualThreadPool();
        virtualThreadPool.setName("jetty-");
        factory.setThreadPool((ThreadPool)virtualThreadPool);
    }

    @Override
    public int getOrder() {
        return 1;
    }
}

