/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.servlet.view;

import grails.util.CacheEntry;
import grails.util.GrailsStringUtils;
import grails.util.GrailsUtil;
import groovy.lang.GroovyObject;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.gsp.GroovyPagesTemplateEngine;
import org.grails.gsp.io.GroovyPageScriptSource;
import org.grails.web.gsp.io.GrailsConventionGroovyPageLocator;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.view.GrailsViewResolver;
import org.grails.web.servlet.view.GroovyPageView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractUrlBasedView;
import org.springframework.web.servlet.view.InternalResourceViewResolver;

public class GroovyPageViewResolver
extends InternalResourceViewResolver
implements GrailsViewResolver {
    private static final Log LOG = LogFactory.getLog(GroovyPageViewResolver.class);
    public static final String GSP_SUFFIX = ".gsp";
    public static final String JSP_SUFFIX = ".jsp";
    protected GroovyPagesTemplateEngine templateEngine;
    protected GrailsConventionGroovyPageLocator groovyPageLocator;
    private ConcurrentMap<String, CacheEntry<View>> viewCache = new ConcurrentHashMap<String, CacheEntry<View>>();
    private boolean allowGrailsViewCaching = !GrailsUtil.isDevelopmentEnv();
    private long cacheTimeout = -1L;
    private boolean resolveJspView = false;

    public GroovyPageViewResolver() {
        this.setCache(false);
        this.setOrder(2147483627);
    }

    public GroovyPageViewResolver(GroovyPagesTemplateEngine templateEngine, GrailsConventionGroovyPageLocator groovyPageLocator) {
        this();
        this.templateEngine = templateEngine;
        this.groovyPageLocator = groovyPageLocator;
    }

    public void setGroovyPageLocator(GrailsConventionGroovyPageLocator groovyPageLocator) {
        this.groovyPageLocator = groovyPageLocator;
    }

    @Override
    protected View loadView(String viewName, Locale locale) throws Exception {
        Assert.notNull((Object)this.templateEngine, "Property [templateEngine] cannot be null");
        if (viewName.endsWith(GSP_SUFFIX)) {
            viewName = viewName.substring(0, viewName.length() - GSP_SUFFIX.length());
        }
        if (!this.allowGrailsViewCaching) {
            return this.createGrailsView(viewName);
        }
        Object viewCacheKey = this.groovyPageLocator.resolveViewFormat(viewName);
        String currentControllerKeyPrefix = this.resolveCurrentControllerKeyPrefixes(viewName.startsWith("/"));
        if (currentControllerKeyPrefix != null) {
            viewCacheKey = currentControllerKeyPrefix + ":" + (String)viewCacheKey;
        }
        CacheEntry entry = (CacheEntry)this.viewCache.get(viewCacheKey);
        final String lookupViewName = viewName;
        Callable<View> updater = new Callable<View>(){

            @Override
            public View call() throws Exception {
                try {
                    return GroovyPageViewResolver.this.createGrailsView(lookupViewName);
                }
                catch (Exception e) {
                    throw new WrappedInitializationException(e);
                }
            }
        };
        View view = null;
        if (entry == null) {
            try {
                return CacheEntry.getValue(this.viewCache, viewCacheKey, this.cacheTimeout, updater);
            }
            catch (CacheEntry.UpdateException e) {
                e.rethrowCause();
                return null;
            }
        }
        try {
            view = entry.getValue(this.cacheTimeout, updater, true, null);
        }
        catch (WrappedInitializationException e) {
            e.rethrowCause();
        }
        return view;
    }

    protected String resolveCurrentControllerKeyPrefixes(boolean absolute) {
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest != null) {
            StringBuilder stringBuilder = new StringBuilder();
            String namespace = webRequest.getControllerNamespace();
            String controller2 = webRequest.getControllerName();
            String pluginContextPath = webRequest.getAttributes() != null && webRequest.getCurrentRequest() != null ? webRequest.getAttributes().getPluginContextPath(webRequest.getCurrentRequest()) : null;
            stringBuilder.append(GrailsStringUtils.isNotEmpty(pluginContextPath) ? pluginContextPath : "-");
            stringBuilder.append(',');
            stringBuilder.append(GrailsStringUtils.isNotEmpty(namespace) ? namespace : "-");
            if (!absolute && GrailsStringUtils.isNotEmpty(controller2)) {
                stringBuilder.append(',');
                stringBuilder.append(controller2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    protected View createGrailsView(String viewName) throws Exception {
        GroovyPageScriptSource scriptSource;
        GroovyObject controller2 = null;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        if (webRequest != null) {
            HttpServletRequest request = webRequest.getCurrentRequest();
            controller2 = webRequest.getAttributes().getController((ServletRequest)request);
        }
        if (controller2 == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Locating GSP view for path " + viewName);
            }
            scriptSource = this.groovyPageLocator.findViewByPath(viewName);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Locating GSP view for controller %s and path %s", controller2, viewName));
            }
            scriptSource = this.groovyPageLocator.findView(controller2, viewName);
        }
        if (scriptSource != null) {
            return this.createGroovyPageView(scriptSource.getURI(), scriptSource);
        }
        return this.createFallbackView(viewName);
    }

    private View createGroovyPageView(String gspView, ScriptSource scriptSource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved GSP view at URI [" + gspView + "]");
        }
        GroovyPageView gspSpringView = new GroovyPageView();
        gspSpringView.setServletContext(this.getServletContext());
        gspSpringView.setUrl(gspView);
        gspSpringView.setApplicationContext(this.getApplicationContext());
        gspSpringView.setTemplateEngine(this.templateEngine);
        gspSpringView.setScriptSource(scriptSource);
        try {
            gspSpringView.afterPropertiesSet();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Initialized GSP view for URI [%s]", gspView));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing GroovyPageView", e);
        }
        return gspSpringView;
    }

    protected View createFallbackView(String viewName) throws Exception {
        if (this.resolveJspView) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("No GSP view found, falling back to locating JSTL view for name [%s]", viewName));
            }
            return this.createJstlView(viewName);
        }
        return null;
    }

    protected View createJstlView(String viewName) throws Exception {
        AbstractUrlBasedView view = this.buildView(viewName);
        view.setApplicationContext(this.getApplicationContext());
        view.afterPropertiesSet();
        return view;
    }

    @Autowired(required=true)
    @Qualifier(value="groovyPagesTemplateEngine")
    public void setTemplateEngine(GroovyPagesTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public long getCacheTimeout() {
        return this.cacheTimeout;
    }

    public void setCacheTimeout(long cacheTimeout) {
        this.cacheTimeout = cacheTimeout;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.viewCache.clear();
    }

    public boolean isAllowGrailsViewCaching() {
        return this.allowGrailsViewCaching;
    }

    public void setAllowGrailsViewCaching(boolean allowGrailsViewCaching) {
        this.allowGrailsViewCaching = allowGrailsViewCaching;
    }

    public void setResolveJspView(boolean resolveJspView) {
        this.resolveJspView = resolveJspView;
    }

    private static class WrappedInitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrappedInitializationException(Throwable cause) {
            super(cause);
        }

        public void rethrowCause() throws Exception {
            if (this.getCause() instanceof Exception) {
                throw (Exception)this.getCause();
            }
            throw this;
        }
    }
}

