/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.monitoring;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.internal.monitoring.executor.AbstractExecutor;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ThreadsMonitoringProcess
extends TimerTask {
    private static final Logger logger = LogService.getLogger();
    private final ThreadsMonitoring threadsMonitoring;
    private final int timeLimitMillis;
    private final InternalDistributedSystem internalDistributedSystem;
    private ResourceManagerStats resourceManagerStats = null;
    private static final boolean SHOW_LOCKS = Boolean.getBoolean("gemfire.threadmonitor.showLocks");
    private static final boolean BATCH_CALLS = Boolean.getBoolean("gemfire.threadmonitor.batchCalls");

    protected ThreadsMonitoringProcess(ThreadsMonitoring tMonitoring, InternalDistributedSystem iDistributedSystem, int timeLimitMillis) {
        this.timeLimitMillis = timeLimitMillis;
        this.threadsMonitoring = tMonitoring;
        this.internalDistributedSystem = iDistributedSystem;
    }

    @VisibleForTesting
    public boolean mapValidation() {
        long currentTime = System.currentTimeMillis();
        HashSet<AbstractExecutor> stuckThreads = new HashSet<AbstractExecutor>();
        HashSet<Long> stuckThreadIds = new HashSet<Long>();
        this.checkForStuckThreads(this.threadsMonitoring.getMonitorMap().values(), currentTime, (executor, stuckTime) -> {
            long threadId = executor.getThreadID();
            stuckThreads.add(executor);
            stuckThreadIds.add(threadId);
            this.addLockOwnerThreadId(stuckThreadIds, threadId);
        });
        Map<Long, ThreadInfo> threadInfoMap = ThreadsMonitoringProcess.createThreadInfoMap(stuckThreadIds);
        int numOfStuck = this.checkForStuckThreads(stuckThreads, currentTime, (executor, stuckTime) -> {
            long threadId = executor.getThreadID();
            logger.warn("Thread {} (0x{}) is stuck", (Object)threadId, (Object)Long.toHexString(threadId));
            executor.handleExpiry(stuckTime, threadInfoMap);
        });
        this.updateNumThreadStuckStatistic(numOfStuck);
        if (numOfStuck == 0) {
            logger.trace("There are no stuck threads in the system");
        } else if (numOfStuck != 1) {
            logger.warn("There are {} stuck threads in this node", (Object)numOfStuck);
        } else {
            logger.warn("There is 1 stuck thread in this node");
        }
        return numOfStuck != 0;
    }

    private int checkForStuckThreads(Collection<AbstractExecutor> executors, long currentTime, StuckAction action) {
        int result = 0;
        for (AbstractExecutor executor : executors) {
            if (executor.isMonitoringSuspended()) continue;
            long startTime = executor.getStartTime();
            if (startTime == 0L) {
                executor.setStartTime(currentTime);
                continue;
            }
            long delta = currentTime - startTime;
            if (delta < (long)this.timeLimitMillis) continue;
            action.run(executor, delta);
            ++result;
        }
        return result;
    }

    private static Map<Long, ThreadInfo> createThreadInfoMap(Set<Long> stuckThreadIds) {
        return ThreadsMonitoringProcess.createThreadInfoMap(stuckThreadIds, SHOW_LOCKS, BATCH_CALLS);
    }

    public static Map<Long, ThreadInfo> createThreadInfoMap(Set<Long> stuckThreadIds, boolean showLocks, boolean batchCalls) {
        return ThreadsMonitoringProcess.createThreadInfoMap(ManagementFactory.getThreadMXBean(), stuckThreadIds, showLocks, batchCalls);
    }

    static Map<Long, ThreadInfo> createThreadInfoMap(ThreadMXBean threadMXBean, Set<Long> stuckThreadIds, boolean showLocks, boolean batchCalls) {
        if (stuckThreadIds.isEmpty()) {
            return Collections.emptyMap();
        }
        logger.info("Obtaining ThreadInfo for {} threads. Configuration: showLocks={} batchCalls={}. This is an expensive operation for the JVM and on most JVMs causes all threads to be paused.", (Object)stuckThreadIds.size(), (Object)showLocks, (Object)batchCalls);
        HashMap<Long, ThreadInfo> result = new HashMap<Long, ThreadInfo>();
        if (batchCalls) {
            ThreadsMonitoringProcess.createThreadInfoMapUsingSingleCall(threadMXBean, stuckThreadIds, showLocks, result);
        } else {
            for (long id : stuckThreadIds) {
                ThreadInfo threadInfo = ThreadsMonitoringProcess.createThreadInfoForSingleThread(threadMXBean, showLocks, id);
                if (threadInfo == null) continue;
                result.put(threadInfo.getThreadId(), threadInfo);
            }
        }
        logger.info("finished obtaining ThreadInfo");
        return result;
    }

    private static ThreadInfo createThreadInfoForSingleThread(ThreadMXBean threadMXBean, boolean showLocks, long id) {
        ThreadInfo threadInfo;
        if (showLocks) {
            ThreadInfo[] threadInfos = threadMXBean.getThreadInfo(new long[]{id}, true, true);
            threadInfo = threadInfos[0];
        } else {
            threadInfo = threadMXBean.getThreadInfo(id, Integer.MAX_VALUE);
        }
        return threadInfo;
    }

    private static void createThreadInfoMapUsingSingleCall(ThreadMXBean threadMXBean, Set<Long> stuckThreadIds, boolean showLocks, Map<Long, ThreadInfo> result) {
        ThreadInfo[] threadInfos;
        long[] ids = new long[stuckThreadIds.size()];
        int idx = 0;
        Iterator<Long> iterator = stuckThreadIds.iterator();
        while (iterator.hasNext()) {
            long id;
            ids[idx] = id = iterator.next().longValue();
            ++idx;
        }
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(ids, showLocks, showLocks)) {
            if (threadInfo == null) continue;
            result.put(threadInfo.getThreadId(), threadInfo);
        }
    }

    private void addLockOwnerThreadId(Set<Long> stuckThreadIds, long threadId) {
        long lockOwnerId = this.getLockOwnerId(threadId);
        if (lockOwnerId != -1L) {
            stuckThreadIds.add(lockOwnerId);
        }
    }

    private long getLockOwnerId(long threadId) {
        ThreadInfo threadInfo = ManagementFactory.getThreadMXBean().getThreadInfo(threadId, 0);
        if (threadInfo != null) {
            return threadInfo.getLockOwnerId();
        }
        return -1L;
    }

    private void updateNumThreadStuckStatistic(int numOfStuck) {
        ResourceManagerStats stats = this.getResourceManagerStats();
        if (stats != null) {
            stats.setNumThreadStuck(numOfStuck);
        }
    }

    @Override
    public void run() {
        this.mapValidation();
    }

    @VisibleForTesting
    public ResourceManagerStats getResourceManagerStats() {
        ResourceManagerStats result = this.resourceManagerStats;
        if (result == null) {
            try {
                if (this.internalDistributedSystem == null || !this.internalDistributedSystem.isConnected()) {
                    return null;
                }
                DistributionManager distributionManager = this.internalDistributedSystem.getDistributionManager();
                InternalCache cache = distributionManager.getExistingCache();
                this.resourceManagerStats = result = cache.getInternalResourceManager().getStats();
            }
            catch (CacheClosedException e1) {
                logger.trace("could not update statistic since cache is closed");
            }
        }
        return result;
    }

    private static interface StuckAction {
        public void run(AbstractExecutor var1, long var2);
    }
}

