/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.GemFireException;
import org.apache.geode.InternalGemFireError;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.control.RebalanceOperation;
import org.apache.geode.cache.control.RebalanceResults;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.RebalanceResultsImpl;
import org.apache.geode.internal.cache.control.RegionFilter;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import org.apache.geode.internal.cache.partitioned.rebalance.CompositeDirector;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RebalanceOperationImpl
implements RebalanceOperation {
    private static final Logger logger = LogService.getLogger();
    private final boolean simulation;
    private final InternalCache cache;
    private final List<Future<RebalanceResults>> futureList = new ArrayList<Future<RebalanceResults>>();
    private int pendingTasks;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Object futureLock = new Object();
    private final RegionFilter filter;

    RebalanceOperationImpl(InternalCache cache, boolean simulation, RegionFilter filter) {
        this.simulation = simulation;
        this.cache = cache;
        this.filter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        InternalResourceManager manager = this.cache.getInternalResourceManager();
        Object object = this.futureLock;
        synchronized (object) {
            manager.addInProgressRebalance(this);
            this.scheduleRebalance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRebalance() {
        ResourceManagerStats stats = this.cache.getInternalResourceManager().getStats();
        long start = stats.startRebalance();
        try {
            for (PartitionedRegion region : this.cache.getPartitionedRegions()) {
                if (this.cancelled.get()) {
                    break;
                }
                try {
                    PartitionedRegionRebalanceOp prOp;
                    if (region.getColocatedWith() != null || !this.filter.include(region)) continue;
                    if (region.isFixedPartitionedRegion()) {
                        if (!Boolean.getBoolean("gemfire.DISABLE_MOVE_PRIMARIES_ON_STARTUP")) continue;
                        prOp = new PartitionedRegionRebalanceOp(region, this.simulation, new CompositeDirector(false, false, false, true), true, true, this.cancelled, stats);
                        this.futureList.add(this.submitRebalanceTask(prOp, start));
                        continue;
                    }
                    prOp = new PartitionedRegionRebalanceOp(region, this.simulation, new CompositeDirector(true, true, true, true), true, true, this.cancelled, stats);
                    this.futureList.add(this.submitRebalanceTask(prOp, start));
                }
                catch (RegionDestroyedException regionDestroyedException) {}
            }
        }
        finally {
            if (this.pendingTasks == 0) {
                stats.endRebalance(start);
            }
        }
    }

    private Future<RebalanceResults> submitRebalanceTask(PartitionedRegionRebalanceOp rebalanceOp, long rebalanceStartTime) {
        InternalResourceManager manager = this.cache.getInternalResourceManager();
        ScheduledExecutorService ex = manager.getExecutor();
        Object object = this.futureLock;
        synchronized (object) {
            ++this.pendingTasks;
            try {
                Future<RebalanceResults> future = ex.submit(() -> {
                    try {
                        RebalanceResultsImpl results = new RebalanceResultsImpl();
                        SystemFailure.checkFailure();
                        this.cache.getCancelCriterion().checkCancelInProgress(null);
                        Set<PartitionRebalanceInfo> detailSet = null;
                        detailSet = rebalanceOp.execute();
                        for (PartitionRebalanceInfo details : detailSet) {
                            results.addDetails(details);
                        }
                        RebalanceResultsImpl rebalanceResultsImpl = results;
                        return rebalanceResultsImpl;
                    }
                    catch (RuntimeException e) {
                        logger.debug("Unexpected exception in rebalancing: {}", (Object)e.getMessage(), (Object)e);
                        throw e;
                    }
                    finally {
                        Object object = this.futureLock;
                        synchronized (object) {
                            --this.pendingTasks;
                            if (this.pendingTasks == 0) {
                                manager.removeInProgressRebalance(this);
                                manager.getStats().endRebalance(rebalanceStartTime);
                            }
                        }
                    }
                });
                return future;
            }
            catch (RejectedExecutionException e) {
                this.cache.getCancelCriterion().checkCancelInProgress(null);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Future<RebalanceResults>> getFutureList() {
        List<Future<RebalanceResults>> list = this.futureList;
        synchronized (list) {
            return this.futureList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel() {
        this.cancelled.set(true);
        Object object = this.futureLock;
        synchronized (object) {
            for (Future<RebalanceResults> fr : this.getFutureList()) {
                if (!fr.cancel(false)) continue;
                --this.pendingTasks;
            }
            if (this.pendingTasks == 0) {
                this.cache.getInternalResourceManager().removeInProgressRebalance(this);
            }
        }
        return true;
    }

    @Override
    public RebalanceResults getResults() throws CancellationException, InterruptedException {
        RebalanceResultsImpl results = new RebalanceResultsImpl();
        List<Future<RebalanceResults>> frlist = this.getFutureList();
        for (Future<RebalanceResults> fr : frlist) {
            try {
                RebalanceResults rr = fr.get();
                results.addDetails((RebalanceResultsImpl)rr);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof GemFireException) {
                    throw (GemFireException)e.getCause();
                }
                if (e.getCause() instanceof InternalGemFireError) {
                    throw (InternalGemFireError)e.getCause();
                }
                throw new InternalGemFireError(e.getCause());
            }
        }
        return results;
    }

    @Override
    public RebalanceResults getResults(long timeout, TimeUnit unit) throws CancellationException, TimeoutException, InterruptedException {
        long endTime = unit.toNanos(timeout) + System.nanoTime();
        RebalanceResultsImpl results = new RebalanceResultsImpl();
        List<Future<RebalanceResults>> frlist = this.getFutureList();
        for (Future<RebalanceResults> fr : frlist) {
            try {
                long waitTime = endTime - System.nanoTime();
                RebalanceResults rr = fr.get(waitTime, TimeUnit.NANOSECONDS);
                results.addDetails((RebalanceResultsImpl)rr);
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof GemFireException) {
                    throw (GemFireException)e.getCause();
                }
                if (e.getCause() instanceof InternalGemFireError) {
                    throw (InternalGemFireError)e.getCause();
                }
                throw new InternalGemFireError(e.getCause());
            }
        }
        return results;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    private boolean isAllDone() {
        for (Future<RebalanceResults> fr : this.getFutureList()) {
            if (fr.isDone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isDone() {
        return this.cancelled.get() || this.isAllDone();
    }

    boolean isSimulation() {
        return this.simulation;
    }
}

