/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.BytesAndBitsForCompactor;
import org.apache.geode.internal.cache.CachedDeserializable;
import org.apache.geode.internal.cache.CachedDeserializableFactory;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class StoreAllCachedDeserializable
implements CachedDeserializable,
DataSerializableFixedID {
    private Object objValue;
    private byte[] value;
    static final int MEM_OVERHEAD = 16;

    public StoreAllCachedDeserializable() {
    }

    StoreAllCachedDeserializable(byte[] serializedValue) {
        if (serializedValue == null) {
            throw new NullPointerException("value must not be null");
        }
        this.value = serializedValue;
        this.objValue = EntryEventImpl.deserialize(this.value);
    }

    public StoreAllCachedDeserializable(Object object) {
        this.objValue = object;
        this.value = EntryEventImpl.serialize(object);
    }

    @Override
    public Object getDeserializedValue(Region r, RegionEntry re) {
        return this.objValue;
    }

    @Override
    public Object getDeserializedForReading() {
        return this.objValue;
    }

    @Override
    public Object getDeserializedWritableCopy(Region r, RegionEntry re) {
        return EntryEventImpl.deserialize(this.value);
    }

    @Override
    public byte[] getSerializedValue() {
        return this.value;
    }

    @Override
    public void fillSerializedValue(BytesAndBitsForCompactor wrapper, byte userBits) {
        wrapper.setData(this.value, userBits, this.value.length, false);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getSizeInBytes() {
        return 16 + CachedDeserializableFactory.getByteSize(this.value) * 2;
    }

    @Override
    public int getValueSizeInBytes() {
        return CachedDeserializableFactory.getByteSize(this.value);
    }

    public int getDSFID() {
        return -57;
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.value = DataSerializer.readByteArray(in);
        this.objValue = EntryEventImpl.deserialize(this.value);
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        DataSerializer.writeByteArray(this.value, out);
    }

    String getShortClassName() {
        String cname = this.getClass().getName();
        return cname.substring(this.getClass().getPackage().getName().length() + 1);
    }

    public String toString() {
        return this.getShortClassName() + "@" + this.hashCode();
    }

    @Override
    public void writeValueAsByteArray(DataOutput out) throws IOException {
        this.toData(out, InternalDataSerializer.createSerializationContext(out));
    }

    @Override
    public String getStringForm() {
        return StringUtils.forceToString(this.objValue);
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }

    @Override
    public boolean isSerialized() {
        return true;
    }

    @Override
    public boolean usesHeapForStorage() {
        return true;
    }
}

