/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.SystemFailure;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class CloseCacheMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private int processorId;

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        boolean systemError = false;
        try {
            try {
                PartitionedRegionHelper.cleanUpMetaDataOnNodeFailure(dm.getCache(), this.getSender());
            }
            catch (VirtualMachineError err) {
                systemError = true;
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                SystemFailure.checkFailure();
                if (logger.isDebugEnabled()) {
                    logger.debug("Throwable caught while processing cache close message from:{}", (Object)this.getSender(), (Object)t);
                }
            }
        }
        finally {
            if (!systemError) {
                ReplyMessage.send(this.getSender(), this.processorId, null, dm, false, false, true);
            }
        }
    }

    public void setProcessorId(int id) {
        this.processorId = id;
    }

    @Override
    public String toString() {
        return super.toString() + " (processorId=" + this.processorId + ")";
    }

    public int getDSFID() {
        return 91;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
    }
}

