/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1;

import java.util.Properties;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.protobuf.security.NoSecurity;
import org.apache.geode.internal.protocol.protobuf.security.NotLoggedInSecurity;
import org.apache.geode.internal.protocol.protobuf.security.SecureCache;
import org.apache.geode.internal.protocol.protobuf.security.SecureCacheImpl;
import org.apache.geode.internal.protocol.protobuf.security.SecureLocator;
import org.apache.geode.internal.protocol.protobuf.security.Security;
import org.apache.geode.internal.protocol.protobuf.security.ShiroSecurity;
import org.apache.geode.internal.protocol.protobuf.statistics.ClientStatistics;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.protocol.serialization.ValueSerializer;
import org.apache.shiro.subject.Subject;

@Experimental
public class ServerMessageExecutionContext
extends MessageExecutionContext {
    private final InternalCache cache;
    private SecureCache secureCache;

    public ServerMessageExecutionContext(InternalCache cache, ClientStatistics statistics, SecurityService securityService) {
        super(statistics, securityService);
        this.cache = cache.getCacheForProcessingClientRequests();
        Security security = securityService.isIntegratedSecurity() ? new NotLoggedInSecurity() : new NoSecurity();
        this.secureCache = new SecureCacheImpl(this.cache, security);
    }

    @Override
    public SecureCache getSecureCache() {
        return this.secureCache;
    }

    @Override
    public SecureLocator getSecureLocator() throws InvalidExecutionContextException {
        throw new InvalidExecutionContextException("Operations on the server should not to try to operate on a locator");
    }

    @Override
    public void authenticate(Properties properties) {
        Subject subject = this.securityService.login(properties);
        this.secureCache = new SecureCacheImpl(this.cache, new ShiroSecurity(this.securityService, subject));
    }

    @Override
    public void setValueSerializer(ValueSerializer valueSerializer) {
        valueSerializer.init(this.cache);
        this.serializationService = new ProtobufSerializationService(valueSerializer);
    }
}

