/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.Query;
import org.apache.geode.cache.query.SelectResults;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.DoubleWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.SortedSetQuery;
import org.apache.geode.redis.internal.executor.sortedset.SortedSetExecutor;

public class ZRemRangeByRankExecutor
extends SortedSetExecutor {
    private final int NONE_REMOVED = 0;
    private final String ERROR_NOT_NUMERIC = "The index provided is not numeric";

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        int stopRank;
        int startRank;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the ZREMRANGEBYRANK command is \"ZREMRANGEBYRANK key start stop\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_SORTEDSET, context);
        Region<ByteArrayWrapper, DoubleWrapper> keyRegion = this.getRegion(context, key);
        if (keyRegion == null) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        try {
            startRank = Coder.bytesToInt(commandElems.get(2));
            stopRank = Coder.bytesToInt(commandElems.get(3));
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The index provided is not numeric"));
            return;
        }
        int sSetSize = keyRegion.size();
        startRank = this.getBoundedStartIndex(startRank, sSetSize);
        stopRank = this.getBoundedEndIndex(stopRank, sSetSize);
        if (stopRank > sSetSize - 1) {
            stopRank = sSetSize - 1;
        }
        if (startRank > stopRank) {
            command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), 0));
            return;
        }
        int numRemoved = 0;
        List<?> removeList = null;
        try {
            if (startRank == 0 && stopRank == sSetSize - 1) {
                numRemoved = keyRegion.size();
                context.getRegionProvider().removeKey(key);
            } else {
                removeList = this.getRemoveKeys(context, key, startRank, stopRank);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (removeList != null) {
            for (Object entry : removeList) {
                ByteArrayWrapper removeKey = entry instanceof Region.Entry ? (ByteArrayWrapper)((Region.Entry)entry).getKey() : (ByteArrayWrapper)((Struct)entry).getFieldValues()[0];
                Object oldVal = keyRegion.remove((Object)removeKey);
                if (oldVal == null) continue;
                ++numRemoved;
            }
            if (keyRegion.isEmpty()) {
                context.getRegionProvider().removeKey(key);
            }
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
    }

    private List<?> getRemoveKeys(ExecutionHandlerContext context, ByteArrayWrapper key, int startRank, int stopRank) throws Exception {
        Query query = this.getQuery(key, SortedSetQuery.ZREMRANGEBYRANK, context);
        Object[] params = new Object[]{stopRank + 1};
        SelectResults results = (SelectResults)query.execute(params);
        return results.asList().subList(startRank, stopRank + 1);
    }
}

