/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HKeysExecutor
extends HashExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        HashSet<ByteArrayWrapper> keys;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HKEYS command is \"HKEYS key\""));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            Map<ByteArrayWrapper, ByteArrayWrapper> keyMap = this.getMap(context, key);
            if (keyMap == null || keyMap.isEmpty()) {
                command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
                return;
            }
            keys = new HashSet<ByteArrayWrapper>(keyMap.keySet());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        if (keys.isEmpty()) {
            command.setResponse(Coder.getEmptyArrayResponse(context.getByteBufAllocator()));
            return;
        }
        this.respondBulkStrings(command, context, keys);
    }
}

