/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.util.List;
import java.util.Map;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.redis.internal.AutoCloseableLock;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;

public class HIncrByExecutor
extends HashExecutor {
    private static final String ERROR_FIELD_NOT_USABLE = "The value at this field is not an integer";
    private static final String ERROR_INCREMENT_NOT_USABLE = "The increment on this key must be numeric";
    private static final String ERROR_OVERFLOW = "This incrementation cannot be performed due to overflow";
    private static final int FIELD_INDEX = 2;
    private static final int INCREMENT_INDEX = 3;

    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        long value;
        long increment;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 4) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the HINCRBY command is \"HINCRBY key field increment\""));
            return;
        }
        byte[] incrArray = commandElems.get(3);
        try {
            increment = Coder.bytesToLong(incrArray);
        }
        catch (NumberFormatException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_INCREMENT_NOT_USABLE));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        try (AutoCloseableLock regionLock = this.withRegionLock(context, key);){
            Map<ByteArrayWrapper, ByteArrayWrapper> map = this.getMap(context, key);
            byte[] byteField = commandElems.get(2);
            ByteArrayWrapper field = new ByteArrayWrapper(byteField);
            ByteArrayWrapper oldValue = map.get(field);
            if (oldValue == null) {
                map.put(field, new ByteArrayWrapper(incrArray));
                this.saveMap(map, context, key);
                command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), increment));
                return;
            }
            try {
                value = Long.parseLong(oldValue.toString());
            }
            catch (NumberFormatException e) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_FIELD_NOT_USABLE));
                if (regionLock != null) {
                    if (var11_11 != null) {
                        try {
                            regionLock.close();
                        }
                        catch (Throwable throwable) {
                            var11_11.addSuppressed(throwable);
                        }
                    } else {
                        regionLock.close();
                    }
                }
                return;
            }
            if (value >= 0L && increment > Long.MAX_VALUE - value || value <= 0L && increment < Long.MIN_VALUE - value) {
                command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), ERROR_OVERFLOW));
                return;
            }
            map.put(field, new ByteArrayWrapper(Coder.longToBytes(value += increment)));
            this.saveMap(map, context, key);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Thread interrupted."));
            return;
        }
        catch (TimeoutException e) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "Timeout acquiring lock. Please try again."));
            return;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), value));
    }
}

